/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.info;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.activities.cmd.info.InfoInstance;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;

public class InfoMedia
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InfoInstance.class);
    @InputOutput(documentation="Barcode", required=true)
    public String barcode;
    @Output(documentation="Storage policy name")
    public String storagePolicy;
    @Output(documentation="Storage policy copy name")
    public String copy;
    @Output(documentation="Location")
    public String location;
    @Output(documentation="Library")
    public String library;
    @Output(documentation="Status")
    public String status;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qinfo media -b '%s'", this.barcode));
        try {
            String string = this.execute(stringBuffer, activityContext);
            CommandUtil.RowData rowData = CommandUtil.parseRowValues(string);
            this.barcode = rowData.getColumn("Name");
            this.storagePolicy = rowData.getColumn("Storage policy");
            this.copy = rowData.getColumn("Copy");
            this.location = rowData.getColumn("Location");
            this.library = rowData.getColumn("Library");
            this.status = rowData.getColumn("Status");
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

