/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.info;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.DataAgent;

public class InfoInstance
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InfoInstance.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @InputOutput(documentation="Instance name, required for a few agents", required=true)
    public String instance;
    @Output(documentation="Command line storage policy name")
    public String cmdStoragePolicy;
    @Output(documentation="Log storage policy name")
    public String logStoragePolicy;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        String string = this.dataAgent == null ? "" : this.dataAgent.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qinfo instance -c '%s' -a '%s'", this.client.getClientName(), string));
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        try {
            String string2 = this.execute(stringBuffer, activityContext);
            CommandUtil.RowData rowData = CommandUtil.parseRowValues(string2);
            this.instance = rowData.getColumn("Name");
            this.cmdStoragePolicy = rowData.getColumn("Commandline storage policy");
            this.logStoragePolicy = rowData.getColumn("Log storage policy");
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

