/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.info;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.DataAgent;

public class InfoBackupset
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InfoBackupset.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Instance name, required for a few agents")
    public String instance;
    @InputOutput(documentation="Backup set name", required=true)
    public String backupSet;
    @Output(documentation="Is Default BackupSet")
    public Boolean defaultBackupSet;
    @Output(documentation="Is On Demand BackupSet")
    public Boolean onDemand;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        String string = this.dataAgent == null ? "" : this.dataAgent.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qinfo backupset -c '%s' -a '%s' -b '%s'", this.client.getClientName(), string, this.backupSet));
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        try {
            String string2 = this.execute(stringBuffer, activityContext);
            CommandUtil.RowData rowData = CommandUtil.parseRowValues(string2);
            this.backupSet = rowData.getColumn("Name");
            this.defaultBackupSet = CommandUtil.parseAnswer(rowData.getColumn("Default"));
            this.onDemand = CommandUtil.parseAnswer(rowData.getColumn("Ondemand"));
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

