/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.delete;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.activities.cmd.delete.DeleteClient;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.Answer;
import workflow.types.cmd.DataAgent;

public class DeleteDataAgent
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DeleteClient.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="iDataAgent to be deleted", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Deconfigure the iDataAgent but do not delete it [yes/no]")
    public Answer deconfigure;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qdelete dataagent -c '%s' -a '%s'", this.client.getClientName(), this.dataAgent));
        if (this.deconfigure != null && this.deconfigure == Answer.yes) {
            stringBuffer.append(" -deconfigure");
        }
        stringBuffer.append(" -y");
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

