/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.Answer;
import workflow.types.cmd.DataAgent;

public class CreateReplicationSet
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateReplicationSet.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="iDataAgent type installed on client computer (Q_FILE_REPLICATION)", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Replication set name", required=true)
    public String replicationSetName;
    @Input(documentation="Replication Set Policy")
    public String replicationSetPolicy;
    @Input(documentation="Destination Host")
    public String destinationHost;
    @Input(documentation="Filter File Path/Pattern")
    public String filterPath;
    @Input(documentation="Allow Recovery Point (y/n)")
    public Answer allowRecoveryPoint;
    @Input(documentation="Common Base Folder")
    public String commonBaseFolder;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qcreate repset -c '%s' -a '%s' -n '%s'", this.client.getClientName(), this.dataAgent, this.replicationSetName));
        if (this.replicationSetPolicy != null && this.replicationSetPolicy.length() > 0) {
            stringBuffer.append(String.format(" -rp '%s'", this.replicationSetPolicy));
        }
        if (this.destinationHost != null && this.destinationHost.length() > 0) {
            stringBuffer.append(String.format(" -dh '%s'", this.destinationHost));
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            stringBuffer.append(String.format(" -fp '%s'", this.filterPath));
        }
        if (this.allowRecoveryPoint != null) {
            if (this.allowRecoveryPoint == Answer.yes) {
                stringBuffer.append(" -arp y");
            } else {
                stringBuffer.append(" -arp n");
            }
        }
        if (this.commonBaseFolder != null && this.commonBaseFolder.length() > 0) {
            stringBuffer.append(String.format(" -commonbasefolder '%s'", this.commonBaseFolder));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

