/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.create.CreateInstance;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.Answer;

public class CreateInstanceOracle
extends CreateInstance {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateInstanceOracle.class);
    @Input(documentation="Host User Name")
    public String hostUser;
    @Input(documentation="NT User Name")
    public String ntUser;
    @Input(documentation="NT Password (in plain text)")
    public String ntPassword;
    @Input(documentation="Oracle Home")
    public String oracleHome;
    @Input(documentation="Connect User")
    public String connectUser;
    @Input(documentation="Connect Password")
    public String connectPassword;
    @Input(documentation="Connect Service")
    public String connectService;
    @Input(documentation="Use Catalog [yes|no]")
    public Answer useCatalog;
    @Input(documentation="Catalog User")
    public String catalogUser;
    @Input(documentation="Catalog Password")
    public String catalogPassword;
    @Input(documentation="Catalog Service")
    public String catalogService;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer;
        try {
            stringBuffer = this.createCommand(activityContext, "Q_ORACLE");
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        if (this.hostUser != null && this.hostUser.length() > 0) {
            stringBuffer.append(String.format(" -hu '%s'", this.hostUser));
        }
        if (this.ntUser != null && this.ntUser.length() > 0) {
            stringBuffer.append(String.format(" -ntu '%s'", this.ntUser));
        }
        if (this.ntPassword != null && this.ntPassword.length() > 0) {
            stringBuffer.append(String.format(" -ntp '%s'", this.ntPassword));
        }
        if (this.oracleHome != null && this.oracleHome.length() > 0) {
            stringBuffer.append(String.format(" -oh '%s'", this.oracleHome));
        }
        if (this.connectUser != null && this.connectUser.length() > 0) {
            stringBuffer.append(String.format(" -ocu '%s'", this.connectUser));
        }
        if (this.connectPassword != null && this.connectPassword.length() > 0) {
            stringBuffer.append(String.format(" -ocp '%s'", this.connectPassword));
        }
        if (this.connectService != null && this.connectService.length() > 0) {
            stringBuffer.append(String.format(" -ocs '%s'", this.connectService));
        }
        if (this.useCatalog != null) {
            stringBuffer.append(String.format(" -ct '%s'", this.useCatalog.toString()));
        }
        if (this.catalogUser != null && this.catalogUser.length() > 0) {
            stringBuffer.append(String.format(" -ctu '%s'", this.catalogUser));
        }
        if (this.catalogPassword != null && this.catalogPassword.length() > 0) {
            stringBuffer.append(String.format(" -ctp '%s'", this.catalogPassword));
        }
        if (this.catalogService != null && this.catalogService.length() > 0) {
            stringBuffer.append(String.format(" -cts '%s'", this.catalogService));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

