/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.create.CreateInstance;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.DB2Type;

public class CreateInstanceDB2
extends CreateInstance {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateInstanceDB2.class);
    @Input(documentation="Agent type installed on client computer")
    public DB2Type type;
    @Input(documentation="DB2 User Name")
    public String user;
    @Input(documentation="DB2 Password (in plain text)")
    public String password;
    @Input(documentation="DB2 Home")
    public String home;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer;
        try {
            stringBuffer = this.createCommand(activityContext, this.type.toString());
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        if (this.user != null && this.user.length() > 0) {
            stringBuffer.append(String.format(" -du '%s'", this.user));
        }
        if (this.password != null && this.password.length() > 0) {
            stringBuffer.append(" -dp " + this.password);
        }
        if (this.home != null && this.home.length() > 0) {
            stringBuffer.append(String.format(" -dh '%s'", this.home));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

