/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.BackupSetType;
import workflow.types.cmd.DataAgent;

public class CreateBackupset
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateBackupset.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Instance name, required for a few agents")
    public String instance;
    @Input(documentation="Name of the backup set to be created", required=true)
    public String backupSet;
    @Input(documentation="Storage policy name to which default subclients are to be associated")
    public String storagePolicy;
    @Input(documentation="Type of backup set (NORMAL, DEFAULT, or ONDEMAND)")
    public BackupSetType type;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qcreate backupset -c '%s' -a '%s' -n '%s'", this.client.getClientName(), this.dataAgent, this.backupSet));
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.storagePolicy != null && this.storagePolicy.length() > 0) {
            stringBuffer.append(String.format(" -sp '%s'", this.storagePolicy));
        }
        if (this.type != null) {
            stringBuffer.append(" -t " + this.type.toString());
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

