/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import workflow.types.SimpleType;

public class XMLQueryActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(XMLQueryActivity.class);
    @Input(documentation="the xml blob to perform the query on")
    public String xml;
    @Input(documentation="the xpath query to execute")
    public String xpath;
    @Input(defaultValue="String", documentation="determines the type the xpath result should be converted to")
    public SimpleType outputType;
    @Input(defaultValue="false", documentation="allows the query to return a list of values")
    public Boolean outputAsList;
    @Output
    public Object result;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.xml == null || this.xml.length() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "xml input parameter into activity is null");
            return AttemptStatus.SUCCESS;
        }
        if (this.xpath == null || this.xpath.length() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "xpath input parameter into activity is null");
            return AttemptStatus.SUCCESS;
        }
        if (this.outputAsList == null) {
            this.outputAsList = true;
        }
        if (this.outputType == null) {
            this.outputType = SimpleType.String;
        }
        try {
            this.result = XMLQuery.query((String)this.xml, (String)this.xpath, (SimpleType)this.outputType, (boolean)this.outputAsList);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

