/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.wsdl.Binding;
import commvault.cte.common.wsdl.BindingOperation;
import commvault.cte.common.wsdl.BindingProtocol;
import commvault.cte.common.wsdl.SOAPOperation;
import commvault.cte.common.wsdl.WSDLSystem;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.activity.XMLActivity;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.converters.DateConverter;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.msgs.Workflow.ActivitySchema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.w3c.dom.Document;

public class WebServiceActivity
implements XMLActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WebServiceActivity.class);
    private static final String[] XML_DATE_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd"};
    private static final String XML_SCHEMA_DATE = "yyyy-MM-dd";
    private static final String XML_SCHEMA_DATETIME = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String NAMESPACE_PREFIX = "ns0";
    private SOAPFactory soapFactory;
    private WSDLSystem wsdl;
    private String inputs;
    private Element headerElement;
    private Element bodyElement;
    private String outputs;
    private Long jobId;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        SOAPElement sOAPElement;
        SOAPHeader sOAPHeader;
        SOAPElement sOAPElement2;
        SOAPBody sOAPBody;
        SOAPEnvelope sOAPEnvelope;
        SOAPPart sOAPPart;
        SOAPMessage sOAPMessage;
        Binding binding;
        Object object;
        String string;
        this.jobId = activityContext.getJobId();
        QName qName = QName.valueOf(activityContext.getOperation());
        logger.info(Long.valueOf(activityContext.getJobId()), "initializing web service activity for operation %s", new Object[]{qName});
        WF_SchemaLocation_t wF_SchemaLocation_t = new WF_SchemaLocation_t();
        try {
            string = String.format("LocationId = %s", activityContext.getLocationId());
            if (!wF_SchemaLocation_t.fill(string)) {
                logger.error(Long.valueOf(activityContext.getJobId()), "could not find schema location for where clause [" + string + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_LOAD_LOCATION", (Object[])new Object[]{activityContext.getDisplayName()});
                activityContext.setFailureReason(evMessageContainer);
                return AttemptStatus.FAILED;
            }
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error retrieving schema location for id [" + activityContext.getLocationId() + "]", (Throwable)exception);
            EvMessageContainer evMessageContainer = new EvMessageContainer(exception.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        if (!wF_SchemaLocation_t.xmlInfo.isNull() && wF_SchemaLocation_t.xmlInfo.get().length() > 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "importing WSDL from database");
            try {
                this.wsdl = WSDLSystem.parse((Reader)new StringReader(wF_SchemaLocation_t.xmlInfo.get()));
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error parsing wsdl [" + wF_SchemaLocation_t.xmlInfo.get() + "]", (Throwable)exception);
                EvMessageContainer evMessageContainer = new EvMessageContainer(exception.getMessage());
                activityContext.setFailureReason(evMessageContainer);
                return AttemptStatus.FAILED;
            }
        }
        logger.info(Long.valueOf(activityContext.getJobId()), "parsing WSDL from [%s]", new Object[]{wF_SchemaLocation_t.LocationUrl.get()});
        try {
            this.wsdl = WSDLSystem.parse((URL)new URL(wF_SchemaLocation_t.LocationUrl.get()));
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error parsing wsdl from URL [" + wF_SchemaLocation_t.LocationUrl.get() + "]", (Throwable)exception);
            EvMessageContainer evMessageContainer = new EvMessageContainer(exception.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        string = this.getBinding(qName);
        if (string == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "could not retrieve binding operation for [" + qName + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_LOAD_WSDL", (Object[])new Object[0]);
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        if (this.inputs != null) {
            try {
                object = JDOMUtil.parseXml((String)this.inputs);
            }
            catch (JDOMException jDOMException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "could not parse web service input xml [" + this.inputs + "]", (Throwable)jDOMException);
                EvMessageContainer evMessageContainer = new EvMessageContainer(jDOMException.getMessage());
                activityContext.setFailureReason(evMessageContainer);
                return AttemptStatus.FAILED;
            }
            if (string.getHeader() != null) {
                this.headerElement = object.getChild(string.getHeader().getName().getLocalPart());
            }
            this.bodyElement = object.getChild(string.getName().getLocalPart());
        }
        if (this.bodyElement == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no web service body to send");
            object = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_LOAD_ACTIVITY_INPUTS", (Object[])new Object[]{activityContext.getDisplayName()});
            activityContext.setFailureReason((EvMessageContainer)object);
            return AttemptStatus.FAILED;
        }
        object = null;
        if (activityContext.getServiceLocation() != null && activityContext.getServiceLocation().length() > 0) {
            object = activityContext.getServiceLocation();
            logger.info(Long.valueOf(activityContext.getJobId()), "found location url [%s] in activity configuration", new Object[]{object});
        } else {
            binding = string.getBinding();
            if (binding.getPorts().length > 0) {
                object = binding.getPorts()[0].getLocation();
                logger.info(Long.valueOf(activityContext.getJobId()), "retrieved service location [%s] from WSDL file", new Object[]{object});
            } else {
                logger.info(Long.valueOf(activityContext.getJobId()), "could not retrieve any ports for operation [%s], check for locally stored service location", new Object[]{qName});
                if (!wF_SchemaLocation_t.serviceUrl.isNull() && wF_SchemaLocation_t.serviceUrl.get().length() > 0) {
                    object = wF_SchemaLocation_t.serviceUrl.get();
                    logger.info(Long.valueOf(activityContext.getJobId()), "found internal service url [%s]", new Object[]{object});
                }
            }
        }
        if (object == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no service locations urls specified");
            binding = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_LOAD_WSDL", (Object[])new Object[0]);
            activityContext.setFailureReason((EvMessageContainer)binding);
            return AttemptStatus.FAILED;
        }
        try {
            this.soapFactory = SOAPFactory.newInstance();
            binding = MessageFactory.newInstance();
            sOAPMessage = binding.createMessage();
        }
        catch (SOAPException sOAPException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error instantiating java soap", (Throwable)sOAPException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(sOAPException.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        if (string.getAction() != null) {
            logger.info(Long.valueOf(activityContext.getJobId()), "adding soap action [%s] to mime header", new Object[]{string.getAction()});
            sOAPPart = sOAPMessage.getMimeHeaders();
            sOAPPart.addHeader("SOAPAction", string.getAction());
        }
        sOAPPart = sOAPMessage.getSOAPPart();
        try {
            sOAPEnvelope = sOAPPart.getEnvelope();
        }
        catch (SOAPException sOAPException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error retrieving soap envelope", (Throwable)sOAPException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(sOAPException.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        try {
            sOAPEnvelope.addNamespaceDeclaration(NAMESPACE_PREFIX, qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error adding namespace declaration, prefix [ns0], uri [" + qName.getNamespaceURI() + "]", (Throwable)sOAPException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(sOAPException.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        try {
            sOAPBody = sOAPMessage.getSOAPBody();
            sOAPElement2 = sOAPBody.addChildElement(this.bodyElement.getName(), NAMESPACE_PREFIX);
            this.configureElement(sOAPElement2, this.bodyElement);
            if (this.headerElement != null) {
                sOAPHeader = sOAPMessage.getSOAPHeader();
                sOAPElement = sOAPHeader.addChildElement(this.headerElement.getName(), NAMESPACE_PREFIX);
                this.configureElement(sOAPElement, this.headerElement);
            }
            sOAPMessage.saveChanges();
        }
        catch (SOAPException sOAPException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error building soap message", (Throwable)sOAPException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(sOAPException.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        try {
            logger.info(Long.valueOf(activityContext.getJobId()), "built soap message [%s]", new Object[]{this.toString(sOAPMessage)});
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to serialize soap message", (Throwable)exception);
        }
        try {
            sOAPElement2 = SOAPConnectionFactory.newInstance();
            sOAPBody = sOAPElement2.createConnection();
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error creating soap connection factory", (Throwable)exception);
            sOAPHeader = new EvMessageContainer(exception.getMessage());
            activityContext.setFailureReason((EvMessageContainer)sOAPHeader);
            return AttemptStatus.FAILED;
        }
        logger.info(Long.valueOf(activityContext.getJobId()), "sending soap message to end point [%s]", new Object[]{object});
        try {
            sOAPElement2 = sOAPBody.call(sOAPMessage, object);
        }
        catch (SOAPException sOAPException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error sending soap message to [" + (String)object + "]", (Throwable)sOAPException);
            sOAPElement = new EvMessageContainer(sOAPException.getMessage());
            activityContext.setFailureReason((EvMessageContainer)sOAPElement);
            return AttemptStatus.FAILED;
        }
        try {
            sOAPBody.close();
        }
        catch (SOAPException sOAPException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error closing soap connection", (Throwable)sOAPException);
        }
        try {
            sOAPHeader = sOAPElement2.getSOAPBody();
        }
        catch (SOAPException sOAPException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error retrieving soap body from response message", (Throwable)sOAPException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(sOAPException.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        if (sOAPHeader.getFault() != null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "recieved fault message in response [" + sOAPHeader.getFault() + "]");
            sOAPElement = new EvMessageContainer(sOAPHeader.getFault().getNodeValue());
            activityContext.setFailureReason((EvMessageContainer)sOAPElement);
            return AttemptStatus.FAILED;
        }
        try {
            logger.info(Long.valueOf(activityContext.getJobId()), "recieved soap message [%s]", new Object[]{this.toString((SOAPMessage)sOAPElement2)});
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to serialize response message", (Throwable)exception);
        }
        try {
            sOAPElement = JDOMUtil.convertFromDOM((Document)sOAPHeader.extractContentAsDocument());
        }
        catch (SOAPException sOAPException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to convert soap message to dom", (Throwable)sOAPException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(sOAPException.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        JDOMUtil.localizeElement((Element)sOAPElement);
        try {
            this.outputs = "<outputs>" + JDOMUtil.serializeXml((Element)sOAPElement) + "</outputs>";
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to serialize response xml", (Throwable)exception);
            EvMessageContainer evMessageContainer = new EvMessageContainer(exception.getMessage());
            activityContext.setFailureReason(evMessageContainer);
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private String toString(SOAPMessage sOAPMessage) throws SOAPException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    private void configureElement(SOAPElement sOAPElement, Element element) throws SOAPException {
        if (element.getChildren().size() > 0) {
            for (Element element2 : element.getChildren()) {
                SOAPElement sOAPElement2 = sOAPElement.addChildElement(element2.getName(), NAMESPACE_PREFIX);
                for (Attribute attribute : element2.getAttributes()) {
                    if (attribute.getName().equals("class")) continue;
                    sOAPElement2.addAttribute(this.soapFactory.createName(attribute.getName()), attribute.getValue());
                }
                this.configureElement(sOAPElement2, element2);
            }
        } else {
            sOAPElement.addTextNode(this.getValue(element));
        }
    }

    private String getValue(Element element) {
        Class<Object> clazz;
        String string = element.getAttributeValue("class");
        if (string == null || string.length() == 0) {
            logger.debug(this.jobId, "input element [%s] is missing class attribute", new Object[]{element.getName()});
            return element.getText();
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.debug(this.jobId, "could not load class [%s] for input property [%s]", new Object[]{string, element.getName()});
            return element.getText();
        }
        if (clazz.isAssignableFrom(String.class)) {
            return element.getText();
        }
        if (Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz)) {
            Date date = (Date)new DateConverter().fromString(element.getText());
            return DateFormatUtils.format((Date)date, (String)XML_SCHEMA_DATE);
        }
        try {
            if (clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Byte.TYPE)) {
                Byte.parseByte(element.getText());
            }
            if (clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Short.TYPE)) {
                Short.parseShort(element.getText());
            }
            if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
                Integer.parseInt(element.getText());
            }
            if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
                Long.parseLong(element.getText());
            }
            if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
                Float.parseFloat(element.getText());
            }
            if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
                Double.parseDouble(element.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn(this.jobId, "input [%s] does not contain a valid value [%s] for type [%s], message [%s]", new Object[]{element.getName(), element.getText(), clazz.getSimpleName(), numberFormatException.getMessage()});
        }
        return element.getText();
    }

    private SOAPOperation getBinding(QName qName) {
        BindingOperation bindingOperation;
        new ArrayList();
        List list = null;
        list = this.wsdl.getBindings(BindingProtocol.SOAP12);
        if (list != null) {
            for (Binding binding : list) {
                bindingOperation = binding.getBindingOperation(qName);
                if (bindingOperation == null) continue;
                return (SOAPOperation)bindingOperation;
            }
        }
        if ((list = this.wsdl.getBindings(BindingProtocol.SOAP)) != null) {
            for (Binding binding : list) {
                bindingOperation = binding.getBindingOperation(qName);
                if (bindingOperation == null) continue;
                return (SOAPOperation)bindingOperation;
            }
        }
        return null;
    }

    public void setInputs(String string) {
        this.inputs = string;
    }

    public String getOutputs() {
        return this.outputs;
    }

    public ActivitySchema getSchema(String string) {
        return null;
    }
}

