/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.FileUploadMonitor;
import commvault.cte.workflow.InputFormManager;
import commvault.cte.workflow.InteractiveAction;
import commvault.cte.workflow.Mailbox;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowMail;
import commvault.cte.workflow.WorkflowMessage;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activities.InteractionActivity;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.activity.XMLOutput;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.db.cs.UMUsers_t;
import commvault.cte.workflow.db.cs.WF_InteractionUsers_t;
import commvault.cte.workflow.db.cs.WF_Interaction_t;
import commvault.cte.workflow.dom.DOMUtil;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.DetermineTransitions;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RepeatActivity;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestManager;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.Workflow.InputAction;
import commvault.msgs.Workflow.InputForm;
import commvault.msgs.Workflow.InputPageRequest;
import commvault.msgs.Workflow.InputPageResponse;
import commvault.msgs.Workflow.InteractionType;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.InteractiveResponse;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import workflow.types.XML;

public class WebFormActivity
extends InteractionActivity
implements XMLOutput,
PhaseHandler,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WebFormActivity.class);
    private static final String ACTION_URL_FRMT = "%s/forms/?tab=1&filter=true&id=%s&interactionId=0&actionName=%s";
    private static final String ACTION_FORM_URL_FRMT = "%s/forms/?interactionId=%s";
    @Input
    public XML inputs;
    @Input
    public List<InputAction> actions;
    @Input
    public String formProperties;
    private String emailBody = "";
    private boolean approvedByEmail = false;
    private InputForm inputForm;
    private String output;
    private String webUrl;
    private InputFormManager manager;
    private String noActionReplyMessage = null;

    @Override
    protected void setInteraction(ActivityContext activityContext, WF_Interaction_t wF_Interaction_t) throws EvFailureException {
        logger.trace("setting interaction with XML inputs [%s], schema [%s]", new Object[]{this.inputs, activityContext.getSchema()});
        WorkflowElement workflowElement = new WorkflowElement("root");
        try {
            XMLEncoder.encode((Object)this.inputForm, (XMLStreamWriter)new commvault.cte.workflow.dom.XMLStreamWriter(workflowElement));
        }
        catch (Exception exception) {
            logger.error("failed to encode message Workflow::InputForm", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        WorkflowElement workflowElement2 = (WorkflowElement)workflowElement.getChildren().get(0);
        workflowElement2.setName("inputForm");
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        String string = workflowEvaluator.parseString(workflowElement2.toString(), true);
        logger.debug("Interaction Form: %s", new Object[]{string});
        wF_Interaction_t.interactionType.set(Integer.valueOf(InteractionType.FORM.getEnumValue()));
        wF_Interaction_t.inputForm.set(string);
    }

    @Override
    protected AttemptStatus performInteraction(ActivityContext activityContext, WF_Interaction_t wF_Interaction_t, UserEntity userEntity) throws EvFailureException {
        WorkflowElement workflowElement;
        logger.info(Long.valueOf(activityContext.getJobId()), "interaction completed by user [%s] with xml [%s]", new Object[]{userEntity.getUserName(), wF_Interaction_t.xmlResults.get()});
        WorkflowElement workflowElement2 = null;
        try {
            workflowElement2 = WorkflowElement.parse((String)wF_Interaction_t.xmlResults.get());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse xml results from interaction [" + wF_Interaction_t.InteractionId.get() + "]");
            throw evFailureException;
        }
        if (workflowElement2 == null) {
            logger.debug(Long.valueOf(activityContext.getJobId()), "missing xml results from interaction [%s]", new Object[]{wF_Interaction_t.InteractionId.get()});
            workflowElement2 = new WorkflowElement("outputs");
        }
        workflowElement2.removeContent("completedBy");
        List list = activityContext.getMarshaller().encode("completedBy", (Object)userEntity);
        if (list != null && list.size() > 0) {
            workflowElement2.addContent(list);
        }
        workflowElement2.removeContent("actionSelected");
        List list2 = activityContext.getMarshaller().encode("actionSelected", (Object)wF_Interaction_t.inputSchema.get());
        if (list2 != null && list2.size() > 0) {
            workflowElement = (WorkflowElement)list2.get(0);
            workflowElement.setAttribute("class", String.class.getName());
            workflowElement2.addContent(workflowElement);
        }
        try {
            workflowElement = (InputForm)XMLDecoder.decode((String)wF_Interaction_t.inputForm.get(), (Object)new InputForm());
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode Workflow::InputForm from xml [" + wF_Interaction_t.inputForm.get() + "]", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        this.updateEntries(workflowElement.getEntries(), workflowElement2);
        SchemaUtils.updateAttributes((XML)workflowElement2, (XMLSchema)activityContext.getSchema().getInputs());
        WorkflowElement workflowElement3 = new WorkflowElement("root");
        try {
            XMLEncoder.encode((Object)workflowElement, (XMLStreamWriter)new commvault.cte.workflow.dom.XMLStreamWriter(workflowElement3));
        }
        catch (Exception exception) {
            logger.error("failed to encode message Workflow::InputForm", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        WorkflowElement workflowElement4 = (WorkflowElement)workflowElement3.getChildren().get(0);
        workflowElement4.setName("completedForm");
        try {
            wF_Interaction_t.completedForm.set(workflowElement4.toString());
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to encode Workflow::InputForm", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            wF_Interaction_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to save interaction row", (Throwable)cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        DOMUtil.checkInputs((WorkflowElement)workflowElement2, (EvalManager)new EvalManager((WorkflowContext)activityContext));
        try {
            FileUploadMonitor fileUploadMonitor = new FileUploadMonitor(workflowElement2, (WorkflowContext)activityContext);
            fileUploadMonitor.upload();
        }
        catch (InterruptedException interruptedException) {
            throw new EvFailureException(new EvMessageContainer(interruptedException.getMessage()));
        }
        this.output = workflowElement2.toString();
        return AttemptStatus.SUCCESS;
    }

    private void updateEntries(List<XMLSchema> list, WorkflowElement workflowElement) {
        for (XMLSchema xMLSchema : list) {
            List list2;
            xMLSchema.setReadOnly(true);
            xMLSchema.getDefaultValues().clear();
            xMLSchema.setDefaultValue("");
            if (xMLSchema.getChildren().size() > 0) {
                list2 = null;
                if (workflowElement != null) {
                    list2 = workflowElement.getChild(xMLSchema.getInputName());
                }
                this.updateEntries(xMLSchema.getChildren(), (WorkflowElement)list2);
                continue;
            }
            if (workflowElement == null) continue;
            list2 = workflowElement.getChildren(xMLSchema.getInputName());
            for (int i = 0; i < list2.size(); ++i) {
                String string = this.getElementValue(xMLSchema.getClassName(), (WorkflowElement)list2.get(i));
                if (i == 0) {
                    xMLSchema.setDefaultValue(string);
                }
                xMLSchema.getDefaultValues().add(string);
            }
        }
    }

    private String getElementValue(String string, WorkflowElement workflowElement) {
        if (string.equals("commvault.msgs.CvEntities.ClientEntity")) {
            String string2 = this.getChildValue(workflowElement, "displayName");
            return string2 != null && string2.length() > 0 ? string2 : this.getChildValue(workflowElement, "clientName");
        }
        if (string.equals("commvault.msgs.CvEntities.ClientGroupEntity")) {
            return this.getChildValue(workflowElement, "clientGroupName");
        }
        if (string.equals("commvault.msgs.CvEntities.CommCellEntity")) {
            return this.getChildValue(workflowElement, "commCellName");
        }
        if (string.equals("commvault.msgs.CvEntities.LibraryEntity")) {
            return this.getChildValue(workflowElement, "libraryName");
        }
        if (string.equals("commvault.msgs.CvEntities.CredentialEntity")) {
            return this.getChildValue(workflowElement, "credentialName");
        }
        if (string.equals("commvault.msgs.CvEntities.MediaAgentEntity")) {
            return this.getChildValue(workflowElement, "mediaAgentName");
        }
        if (string.equals("commvault.msgs.CvEntities.StoragePolicyEntity")) {
            return this.getChildValue(workflowElement, "storagePolicyName");
        }
        if (string.equals("commvault.msgs.CvEntities.SchedulePolicyEntity")) {
            return this.getChildValue(workflowElement, "schedulePolicyName");
        }
        if (string.equals("commvault.msgs.CvEntities.ExternalGroupEntity")) {
            return this.getChildValue(workflowElement, "externalGroupName");
        }
        if (string.equals("commvault.msgs.CvEntities.UserEntity")) {
            return this.getChildValue(workflowElement, "userName");
        }
        if (string.equals("commvault.msgs.CvEntities.UserGroupEntity")) {
            return this.getChildValue(workflowElement, "userGroupName");
        }
        if (string.equals("commvault.msgs.CvEntities.WorkflowEntity")) {
            return this.getChildValue(workflowElement, "workflowName");
        }
        if (string.equals("workflow.types.File")) {
            return this.getChildValue(workflowElement, "name");
        }
        return workflowElement.getText();
    }

    private String getChildValue(WorkflowElement workflowElement, String string) {
        WorkflowElement workflowElement2 = workflowElement.getChild(string);
        if (workflowElement2 == null) {
            return "";
        }
        return workflowElement2.getText();
    }

    public String getOutputs() {
        return this.output;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public boolean isApprovedByEmail() {
        return this.approvedByEmail;
    }

    @Override
    protected void onEmailApprovalRequest(WorkflowMessage workflowMessage, ActivityContext activityContext) {
        Object object;
        StringBuffer stringBuffer;
        Object object22;
        Object object3;
        Object object4;
        Object object52;
        List list;
        if (workflowMessage.getSubject().toLowerCase().startsWith("Out of Office:".toLowerCase())) {
            logger.debug(Long.valueOf(activityContext.getJobId()), "skipping Out of Office reply from [%s]", new Object[]{workflowMessage.getFrom()});
            return;
        }
        if (logger.getLevel().toInt() > 3) {
            logger.info(Long.valueOf(activityContext.getJobId()), "received approval email from [%s], subject [%s], message [%s]", new Object[]{workflowMessage.getFrom(), workflowMessage.getSubject(), workflowMessage.getBody()});
        } else {
            logger.info(Long.valueOf(activityContext.getJobId()), "received approval email from [%s], subject [%s]", new Object[]{workflowMessage.getFrom(), workflowMessage.getSubject()});
        }
        try {
            list = UMUsers_t.select((String)String.format("email = '%s'", workflowMessage.getFrom()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to read from UMUsers table", (Throwable)cTEDBException);
            return;
        }
        int n = 0;
        if (list.size() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "could not find any user with email address [" + workflowMessage.getFrom() + "]");
            return;
        }
        for (Object object52 : list) {
            try {
                if (!CommServUtils.isInteractionApprover((int)activityContext.getSubJobId().intValue(), (int)((UMUsers_t)object52).id.get())) continue;
                n = ((UMUsers_t)object52).id.get();
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to check if user id [" + ((UMUsers_t)object52).id.get() + "] has capability to perform interaction");
            }
        }
        if (n == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "could not find any user with email address [" + workflowMessage.getFrom() + "] that has approval capability on interaction with subject [" + workflowMessage.getSubject() + "]");
            return;
        }
        if (workflowMessage.getContentType().toLowerCase().indexOf("html") > -1) {
            logger.debug("message with subject [%s] has html body, begin parsing", new Object[]{workflowMessage.getSubject()});
            object52 = new StringBuffer();
            object4 = new HTMLEditorKit.ParserCallback((StringBuffer)object52){
                final /* synthetic */ StringBuffer val$buffer;
                {
                    this.val$buffer = stringBuffer;
                }

                @Override
                public void handleText(char[] cArray, int n) {
                    if (this.val$buffer.length() == 0) {
                        this.val$buffer.append(cArray);
                    }
                }
            };
            ParserDelegator parserDelegator = new ParserDelegator();
            try {
                parserDelegator.parse(new StringReader(workflowMessage.getBody()), (HTMLEditorKit.ParserCallback)object4, Boolean.TRUE);
                object3 = ((StringBuffer)object52).toString();
            }
            catch (IOException iOException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse html content [" + workflowMessage.getBody() + "]", (Throwable)iOException);
                object3 = workflowMessage.getBody();
            }
        } else {
            object3 = workflowMessage.getBody();
        }
        if (((String)(object3 = ((String)object3).trim())).length() > 0) {
            object4 = StringUtils.split((String)object3, (char)'\n');
            object52 = object4[0].trim();
            logger.debug("message with subject [%s] contained action [%s]", new Object[]{workflowMessage.getSubject(), object52});
        } else {
            logger.warn("no body received for message with subject [%s]", new Object[]{workflowMessage.getSubject()});
            object52 = "";
        }
        object4 = null;
        for (Object object22 : this.actions) {
            if (!object22.getName().equalsIgnoreCase((String)object52)) continue;
            object4 = object22.getName();
        }
        int n2 = workflowMessage.getBody().indexOf((String)object52);
        if (n2 == -1) {
            logger.warn("did not find the index for action [" + (String)object52 + "] in body");
            n2 = 0;
        }
        object22 = workflowMessage.getBody().substring(n2 + ((String)object52).length());
        String string = this.getFromAddress(activityContext);
        if (string != null && string.length() > 0) {
            stringBuffer = new StringBuffer();
            object = new Scanner((String)object22);
            boolean bl = false;
            boolean bl2 = false;
            while (((Scanner)object).hasNext()) {
                String string2 = ((Scanner)object).nextLine();
                if (string2.contains(string)) {
                    bl2 = true;
                    break;
                }
                if (bl) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(string2);
                bl = true;
            }
            ((Scanner)object).close();
            if (!bl2) {
                logger.warn("did not find from email address [" + string + "] in body");
            }
            this.emailBody = stringBuffer.toString().trim();
        } else {
            logger.warn("from address not configured to search body with");
            this.emailBody = object22;
        }
        if (object4 == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "action [" + (String)object52 + "], received via email from [" + workflowMessage.getFrom() + "], is not a valid action");
            stringBuffer = new WorkflowMail((WorkflowContext)activityContext);
            if (this.noActionReplyMessage == null || this.noActionReplyMessage.length() == 0) {
                object = new StringBuffer("Invalid response received.  Possible responses:\n");
                for (InputAction inputAction : this.actions) {
                    ((StringBuffer)object).append(inputAction.getName()).append('\n');
                }
                try {
                    stringBuffer.send(Mailbox.getInstance().getReplyTo(), workflowMessage.getFrom(), workflowMessage.getSubject(), ((StringBuffer)object).toString());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to reply to recipient [" + workflowMessage.getFrom() + "] with message [" + ((StringBuffer)object).toString() + "]");
                }
            } else {
                try {
                    stringBuffer.send(Mailbox.getInstance().getReplyTo(), workflowMessage.getFrom(), workflowMessage.getSubject(), this.noActionReplyMessage, true);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to reply to recipient [" + workflowMessage.getFrom() + "] with message [" + this.noActionReplyMessage + "]");
                }
            }
            return;
        }
        stringBuffer = null;
        try {
            stringBuffer = this.processRequest(this.inputs.toString(), (String)object4, n, activityContext);
        }
        catch (EvFailureException evFailureException) {
            // empty catch block
        }
        if (stringBuffer != null) {
            if (stringBuffer.getErrorCode() == 0) {
                this.approvedByEmail = true;
            } else {
                logger.error("error processing request, error code [" + stringBuffer.getErrorCode() + "], message [" + stringBuffer.getErrorMessage() + "]");
            }
        }
    }

    private UMUsers_t findApprover(List<UMUsers_t> list) {
        for (UMUsers_t uMUsers_t : list) {
            WF_InteractionUsers_t wF_InteractionUsers_t = new WF_InteractionUsers_t();
            try {
                if (!wF_InteractionUsers_t.fill(String.format("userId=%s", uMUsers_t.id.get()))) continue;
                return uMUsers_t;
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to select from WF_InteractionUsers table", (Throwable)cTEDBException);
            }
        }
        return null;
    }

    public InputForm getForm() {
        return this.inputForm;
    }

    public void setInput(String string, Object object) {
        for (XMLSchema xMLSchema : this.getForm().getEntries()) {
            if (!xMLSchema.getName().equalsIgnoreCase(string)) continue;
            xMLSchema.setDefaultValue(String.valueOf(object));
            xMLSchema.getDefaultValues().clear();
            xMLSchema.getDefaultValues().add(String.valueOf(object));
        }
    }

    public String getInput(String string) {
        for (XMLSchema xMLSchema : this.getForm().getEntries()) {
            if (!xMLSchema.getName().equalsIgnoreCase(string)) continue;
            return xMLSchema.getDefaultValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(InteractiveRequest interactiveRequest, WorkflowContext workflowContext) throws EvFailureException {
        Object object = workflowContext.getLock();
        synchronized (object) {
            if (interactiveRequest instanceof InputPageRequest) {
                InputPageResponse inputPageResponse = new InputPageResponse();
                InputPageRequest inputPageRequest = (InputPageRequest)interactiveRequest;
                try {
                    inputPageResponse.setInput(this.manager.process(inputPageRequest));
                }
                catch (Throwable throwable) {
                    logger.error(Long.valueOf(workflowContext.getJobId()), "failed to process input search request [" + inputPageRequest.getInput().getInputName() + "], inputs [" + String.valueOf(this.inputs) + "]", throwable);
                }
                RequestManager.populateInteractiveResponse((InteractiveResponse)inputPageResponse, (WorkflowContext)workflowContext);
                SessionManager.getInstance().sendResponse(workflowContext, (CTEProcessingModel)inputPageResponse, (InteractiveAction)this);
            } else {
                super.actionPerformed(interactiveRequest, workflowContext);
            }
        }
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new initializeMail(), new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new BuildForm(), new ProcessOnEnter(), new InitSearchableManager(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs(), new RepeatActivity(), new DetermineTransitions()};
    }

    @Override
    protected void sendEmail(ActivityContext activityContext, WF_Interaction_t wF_Interaction_t) throws EvFailureException {
        if (this.email != null) {
            String string;
            try {
                string = this.parseActions(activityContext, this.email.getBody(), wF_Interaction_t);
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse actions from email body", (Throwable)exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
            string = string.replaceAll("(?i)#\\{InteractionId}", String.valueOf(activityContext.getSubJobId()));
            this.email.setBody(string);
        }
        super.sendEmail(activityContext, wF_Interaction_t);
    }

    private String parseActions(ActivityContext activityContext, String string, WF_Interaction_t wF_Interaction_t) throws Exception {
        Pattern pattern = Pattern.compile("(?i)action:\\{[^}]+}|\\$FORM_URL\\$");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2;
            String string3 = matcher.group();
            if (string3.equalsIgnoreCase("$FORM_URL$")) {
                string2 = this.getFormUrl(wF_Interaction_t.InteractionId.get());
                logger.debug("replace expression [%s] with url [%s]", new Object[]{string3, string2});
            } else {
                String string4 = ExpressionUtils.getExpression((String)string3);
                string2 = this.getActionUrl(wF_Interaction_t.InteractionId.get(), wF_Interaction_t.interactionGuid.get(), string4);
                logger.debug("replace expression [%s], action [%s] with url [%s]", new Object[]{string3, string4, string2});
            }
            matcher.appendReplacement(stringBuffer, string2);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String getActionUrl(int n, String string, String string2) throws Exception {
        if (this.webUrl == null) {
            this.webUrl = WorkflowProperties.getInstance().getWebConsoleUrl();
            if (this.webUrl == null) {
                logger.warn("did not find a default webconsole URL");
                this.webUrl = "";
            } else if (this.webUrl.endsWith("/")) {
                this.webUrl = this.webUrl.substring(0, this.webUrl.length() - 1);
            }
        }
        return String.format(ACTION_URL_FRMT, this.webUrl, string, URLEncoder.encode(string2, "UTF-8"));
    }

    private String getFormUrl(int n) throws Exception {
        if (this.webUrl == null) {
            this.webUrl = WorkflowProperties.getInstance().getWebConsoleUrl();
            if (this.webUrl == null) {
                logger.warn("did not find a default webconsole URL");
                this.webUrl = "";
            }
        }
        return String.format(ACTION_FORM_URL_FRMT, this.webUrl, n);
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
        logger.debug(Long.valueOf(activityContext.getJobId()), "begin processing expressions for inputs into activity [%s], xml [%s]", new Object[]{activityContext.getFriendlyName(), workflowElement.toString()});
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        for (WorkflowElement workflowElement2 : workflowElement.getChildren()) {
            if (workflowElement2.getName().equalsIgnoreCase("formProperties")) continue;
            workflowEvaluator.processChildElement(workflowElement2);
        }
    }

    public String getMissingActionReply() {
        return this.noActionReplyMessage;
    }

    public void setMissingActionReply(String string) {
        this.noActionReplyMessage = string;
    }

    public class InitSearchableManager
    implements ProcessHandler {
        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            WebFormActivity.this.manager = new InputFormManager(WebFormActivity.this.inputForm, false);
        }
    }

    public class BuildForm
    implements ProcessHandler {
        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            try {
                WebFormActivity.this.inputForm = WorkflowUtils.getUserInputForm((ActivityContext)activityContext, (XML)WebFormActivity.this.inputs, (String)WebFormActivity.this.formProperties);
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error building input form from inputs [" + WebFormActivity.this.inputs + "]", (Throwable)evFailureException);
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
            if (WebFormActivity.this.actions == null) {
                WebFormActivity.this.actions = new ArrayList<InputAction>();
            }
            WebFormActivity.this.inputForm.setActions(WebFormActivity.this.actions);
        }
    }

    private class initializeMail
    implements ProcessHandler {
        private initializeMail() {
        }

        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            WebFormActivity.this.mail = new WorkflowMail();
        }
    }
}

