/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.db.WorkflowConnection;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class WaitForJobCompletion
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WaitForJobCompletion.class);
    private static final String CHECK_QUERY = "select jobId from JMJobInfo with(nolock) where jobId in (%s) and state not in (4,10,11,12)";
    private static final long TIMEOUT_TIME = 300000L;
    @Input(documentation="a list of CommServ job ids you want to monitor")
    public List<Integer> jobId;
    @Output
    public Set<Integer> successfullJobs;
    @Output
    public Set<Integer> failedJobs;
    @Output
    public Boolean successful;
    private long startTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        this.startTime = Calendar.getInstance().getTimeInMillis();
        this.successfullJobs = new HashSet<Integer>();
        this.failedJobs = new HashSet<Integer>();
        this.successful = false;
        if (this.jobId == null || this.jobId.size() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "no job id(s) were provided to monitor");
            return AttemptStatus.SUCCESS;
        }
        if (this.jobId.remove(activityContext.getJobId())) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "cannot monitor activity's own job id [%s], removing job from list", new Object[]{activityContext.getJobId()});
        }
        if (this.jobId.size() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "no job id(s) were provided to monitor in activity [%s]", new Object[]{activityContext.getFriendlyName()});
            return AttemptStatus.SUCCESS;
        }
        Object object = "";
        boolean bl = this.sessionOptions.useImpersonatedAccount == null || this.sessionOptions.useImpersonatedAccount != false;
        long l = WorkflowRegistry.getInstance().getJobPullingInterval() * 1000;
        while (true) {
            Object object2 = activityContext.getLock();
            synchronized (object2) {
                activityContext.getLock().wait(l);
                if (bl) {
                    try {
                        this.checkJobDBQuery(activityContext);
                    }
                    catch (EvFailureException evFailureException) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "failed to check status on running jobs");
                        activityContext.setFailureReason(evFailureException.getMessageContainer());
                        return AttemptStatus.FAILED;
                    }
                }
                Object object3 = this.jobId.iterator();
                while (object3.hasNext() && activityContext.getStatus() == ProcessStatus.RUNNING && activityContext.isRunning()) {
                    String string;
                    int n = object3.next();
                    if ((long)n == activityContext.getJobId()) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "cannot monitor activity's own job id [" + n + "]");
                        object3.remove();
                        continue;
                    }
                    try {
                        string = this.checkJobQList(n, activityContext);
                    }
                    catch (EvFailureException evFailureException) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "failed to check status for job id [" + n + "]");
                        activityContext.setFailureReason(evFailureException.getMessageContainer());
                        return AttemptStatus.FAILED;
                    }
                    JOB_STATUS jOB_STATUS = this.getJobStatus(string);
                    logger.trace(Long.valueOf(activityContext.getJobId()), "recieved internal status of [%s] for job [%s], status [%s]", new Object[]{jOB_STATUS, n, string});
                    if (jOB_STATUS != JOB_STATUS.RUNNING) {
                        logger.info(Long.valueOf(activityContext.getJobId()), "job [%s] completed with status [%s]", new Object[]{n, string});
                        if (jOB_STATUS == JOB_STATUS.SUCCESS) {
                            this.successfullJobs.add(n);
                        } else {
                            this.failedJobs.add(n);
                        }
                        object3.remove();
                    }
                    activityContext.getLock().wait(1000L);
                }
                if (this.jobId.size() == 0) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "completed monitoring of all job(s)");
                    this.successful = this.failedJobs.size() == 0;
                    return AttemptStatus.SUCCESS;
                }
                if (activityContext.getStatus() != ProcessStatus.RUNNING) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since it has a status of [%s]", new Object[]{activityContext.getStatus()});
                    activityContext.repeat(Integer.valueOf(0));
                    return AttemptStatus.SUCCESS;
                }
                if (!activityContext.isRunning()) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since the workflow is shutting down");
                    activityContext.repeat(Integer.valueOf(0));
                    return AttemptStatus.SUCCESS;
                }
                object3 = this.jobId.toString();
                if (!((String)object3).equals(object)) {
                    object = object3;
                    logger.info(Long.valueOf(activityContext.getJobId()), "activity is waiting on jobs %s", new Object[]{object});
                    EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_WAITING_ON_JOB", (Object[])new Object[]{object});
                    activityContext.setFailureReason(evMessageContainer);
                    activityContext.save();
                    activityContext.getJobManager().updatePendingReason();
                }
            }
        }
    }

    private JOB_STATUS getJobStatus(String string) {
        if (string == null) {
            return JOB_STATUS.RUNNING;
        }
        if (string.equalsIgnoreCase("Completed") || string.equalsIgnoreCase("Completed w/ one or more errors")) {
            return JOB_STATUS.SUCCESS;
        }
        if (string.equalsIgnoreCase("Failed") || string.equalsIgnoreCase("Killed")) {
            return JOB_STATUS.FAILED;
        }
        return JOB_STATUS.RUNNING;
    }

    private void checkJobDBQuery(ActivityContext activityContext) throws EvFailureException, InterruptedException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.jobId.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.jobId.get(i));
        }
        String string = String.format(CHECK_QUERY, stringBuffer.toString());
        logger.trace(Long.valueOf(activityContext.getJobId()), "checking running jobs via query [%s]", new Object[]{string});
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try (CTEDBReservation cTEDBReservation = activityContext.getContext().getCommCellConnection().createReservation();){
            object = cTEDBReservation.createStatement(string);
            ResultSet resultSet = object.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getInt(1));
            }
        }
        object = new ArrayList();
        for (Integer n : this.jobId) {
            if (arrayList.contains(n)) continue;
            object.add(n);
        }
        if (object.size() > 0) {
            this.checkJobs((List<Integer>)object, activityContext);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkJobs(List<Integer> list, ActivityContext activityContext) throws EvFailureException, InterruptedException {
        void var7_8;
        Object object;
        Object object2;
        Object object3;
        logger.trace(Long.valueOf(activityContext.getJobId()), "checking completed jobs %s", new Object[]{list});
        StringBuffer stringBuffer = new StringBuffer();
        for (Integer n : list) {
            stringBuffer.append(String.format("<jobId val=\"%s\"/>", n));
        }
        String string = String.format("<JobManager_JobListRequest><jobFilter completedJobLookupTime=\"259200000\">%s</jobFilter></JobManager_JobListRequest>", stringBuffer.toString());
        try (CTEDBReservation cTEDBReservation = activityContext.getContext().getCommCellConnection().createReservation();){
            if (WorkflowConnection.JTDS_CONNECTION) {
                object3 = "exec JMGetRunningJobSummary ?,?,null";
                object2 = cTEDBReservation.createStatement((String)object3);
                object2.setInt(1, activityContext.getContext().getUserId());
                object2.setString(2, string);
                object = object2.executeQuery();
                if (!object.next()) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve output from stored procedure [JMGetRunningJobSummary] with xml [" + (String)string + "]");
                    throw new EvFailureException(new EvMessageContainer("failed to execute sp JMGetRunningJobSummary"));
                }
                String string2 = object.getString(1);
            } else {
                object3 = cTEDBReservation.createCallableStatement("{call JMGetRunningJobSummary(?,?,?)}");
                object3.setInt(1, activityContext.getContext().getUserId());
                object3.setString(2, string);
                object3.registerOutParameter(3, 2009);
                object3.execute();
                String string3 = object3.getString(3);
            }
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "executed sp [JMGetRunningJobSummary] with input xml [%s], resulted in output xml [%s]", new Object[]{string, var7_8});
        object3 = WorkflowElement.parse((String)var7_8);
        object = "/JobManager_JobListResponse/jobs/jobSummary";
        try {
            object2 = object3.select((String)object);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [" + (String)object + "]", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (object2 == null || object2.size() <= 0) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "did not find any job summary results from [JMGetRunningJobSummary] with job list [%s]", new Object[]{list.toString()});
            return;
        } else {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                WorkflowElement workflowElement = (WorkflowElement)iterator.next();
                int n = Integer.parseInt(workflowElement.getAttributeValue("jobId"));
                String string4 = workflowElement.getAttributeValue("status");
                JOB_STATUS jOB_STATUS = this.getJobStatus(string4);
                if (jOB_STATUS == JOB_STATUS.SUCCESS) {
                    this.successfullJobs.add(n);
                } else {
                    this.failedJobs.add(n);
                }
                this.jobId.remove((Object)n);
            }
        }
    }

    private String checkJobQList(Integer n, ActivityContext activityContext) throws EvFailureException, InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qlist job -j %s -co s", n));
        String string = this.execute(stringBuffer, activityContext, true);
        if (string.trim().length() == 0) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "qlist command for job id [%s] did not return a result", new Object[]{n});
            return null;
        }
        if (string.equals("No jobs to display.")) {
            long l = Calendar.getInstance().getTimeInMillis() - this.startTime;
            if (l < 300000L) {
                logger.debug("could not find job id from response [%s]", new Object[]{string});
                return null;
            }
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve job information from qlist command for job id [" + n + "] with response [" + string + "]");
            throw new EvFailureException(new EvMessageContainer(string));
        }
        List<String> list = CommandUtil.parseSingleValue(string);
        if (list.size() < 3) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "failed to retrieve status from command output [%s], data %s", new Object[]{string, list.toString()});
            return null;
        }
        return list.get(2);
    }

    private static enum JOB_STATUS {
        RUNNING,
        SUCCESS,
        FAILED;

    }
}

