/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.VMUtilities;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.activity.CharacterEncoding;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.DetermineTransitions;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RepeatActivity;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.CreateTaskResp;
import commvault.msgs.Workflow.GenericResp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.UUID;

public abstract class VMOperationsHandler
extends TokenActivity
implements CharacterEncoding,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(VMOperationsHandler.class);
    protected String outputXml;
    protected String commandArgs;
    protected String errMsg;
    protected int errCode;
    protected List<String> jobIDs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus executeVMOperation(String string, ActivityContext activityContext) throws InterruptedException {
        Object object;
        CharSequence charSequence;
        File file = null;
        if (string != null && string.length() > 0) {
            try {
                string = WorkflowUtils.encodeXml((String)string);
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to encode xml [" + string + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            charSequence = UUID.randomUUID().toString() + ".xml";
            logger.debug(Long.valueOf(activityContext.getJobId()), "creating file [%s] to place the inputted xml contents into", new Object[]{charSequence});
            file = new File(WorkflowRegistry.getInstance().getGalaxyTempDir(), (String)charSequence);
            try {
                object = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                if (string != null) {
                    ((Writer)object).write(string);
                }
                ((OutputStreamWriter)object).close();
            }
            catch (IOException iOException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to write xml to file [" + file.getAbsolutePath() + "]", (Throwable)iOException);
                EvMessageContainer evMessageContainer = new EvMessageContainer("failed to write xml to file [%s]", new Object[]{file.getAbsolutePath()});
                activityContext.setFailureReason(evMessageContainer);
                return AttemptStatus.FAILED;
            }
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("qoperation execute");
        if (this.commandArgs != null && this.commandArgs.length() > 0) {
            if (this.commandArgs.toLowerCase().indexOf("-af") > -1) {
                if (file != null) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "ignoring inputXml parameter since -af parameter was passed into the commandArgs parameter");
                }
                ((StringBuffer)charSequence).append(String.format(" %s", this.commandArgs));
            } else {
                if (file != null) {
                    ((StringBuffer)charSequence).append(String.format(" -af '%s'", file.getAbsolutePath()));
                }
                ((StringBuffer)charSequence).append(String.format(" %s", this.commandArgs));
            }
        } else if (file != null) {
            ((StringBuffer)charSequence).append(String.format(" -af '%s'", file.getAbsolutePath()));
        }
        try {
            this.outputXml = super.execute((StringBuffer)charSequence, activityContext);
            if (this.outputXml.trim().length() > 0) {
                object = XMLDecoder.decode((String)this.outputXml, (Object)new GenericResp());
                if (object instanceof GenericResp) {
                    GenericResp genericResp = (GenericResp)object;
                    this.errCode = genericResp.getErrorCode();
                    this.errMsg = genericResp.getErrorMessage();
                    this.errMsg = this.errMsg.replaceAll("^\"|\"$", "");
                } else if (object instanceof CreateTaskResp) {
                    this.jobIDs = ((CreateTaskResp)object).getJobIds();
                }
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        catch (Exception exception) {
            activityContext.setFailureReason(exception.getLocalizedMessage());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return AttemptStatus.SUCCESS;
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs(), new RepeatActivity(), new DetermineTransitions()};
    }
}

