/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.VMUtilities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.VMUtilities.VMOperationType;
import commvault.cte.workflow.activities.VMUtilities.VMOperationsHandler;
import commvault.cte.workflow.activities.VMUtilities.VMUtilHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.EncryptedString;

public class ExecuteScriptInGuestOS
extends VMOperationsHandler {
    private static final long serialVersionUID = 1L;
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ExecuteScriptInGuestOS.class);
    @Input(documentation="The Virtual Machine Client Name", required=false)
    public ClientEntity vmClientName;
    @Input(documentation="The Virtual Machine Name", required=false)
    public String vmName;
    @Input(documentation="The Virtual Machine GUID", required=false)
    public String vmGUID;
    @Input(documentation="The Virtualization Client Name", required=true)
    public ClientEntity virtualizationClient;
    @Input(documentation="The UNC Path Flag", defaultValue="false")
    public Boolean isUNCPath;
    @Input(documentation="The Script Path", required=true)
    public String scriptPath;
    @Input(documentation="The Script Log", required=true)
    public String scriptLog;
    @Input(documentation="The UNC Path Username", required=false)
    public String uncPathUserName;
    @Input(documentation="The UNC Path user's password", required=false)
    public EncryptedString uncPathPassword;
    @Input(documentation="The VM Guest OS username", required=true)
    public String guestOSUserName;
    @Input(documentation="The VM Guest OS user's password", required=true)
    public EncryptedString guestOSPassword;
    @Input(documentation="The VSA Proxy Client Name", required=true)
    public ClientEntity vsaProxyClient;
    @Input(documentation="Time out in Seconds", required=false, defaultValue="60")
    public int timeOutInSeconds;
    @Output(documentation="return vm operations error code")
    public int errorCode;
    @Output(documentation="return vm operations error message")
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        String string = "";
        VMUtilHandler vMUtilHandler = new VMUtilHandler();
        if (this.virtualizationClient != null && this.virtualizationClient.getClientName().length() > 0) {
            if (this.vmClientName != null || this.vmGUID.length() > 0) {
                if (this.isUNCPath.booleanValue() && (this.uncPathUserName.isEmpty() || this.uncPathPassword.getPlainText().isEmpty())) {
                    String string2 = String.format("Unable to perform Execute Script in Guest OS Operation, UNC Path Username or password is not provided", new Object[0]);
                    logger.error(string2);
                    activityContext.setFailureReason(string2);
                    return AttemptStatus.FAILED;
                }
                if (this.isUNCPath.booleanValue() && (this.guestOSUserName.isEmpty() || this.guestOSPassword.getPlainText().isEmpty())) {
                    String string3 = String.format("Unable to perform Execute Script in Guest OS Operation, Guest OS  Username or password is not provided", new Object[0]);
                    logger.error(string3);
                    activityContext.setFailureReason(string3);
                    return AttemptStatus.FAILED;
                }
                if (this.vsaProxyClient == null || this.vsaProxyClient.getClientId() <= 1 || this.vsaProxyClient.getClientName().isEmpty()) {
                    String string4 = String.format("Unable to perform Execute Script in Guest OS Operation, Prorivde VSA Proxy client name", new Object[0]);
                    logger.error(string4);
                    activityContext.setFailureReason(string4);
                    return AttemptStatus.FAILED;
                }
                string = vMUtilHandler.prepareGuestScriptOperationXML(this.scriptPath, this.scriptLog, this.vsaProxyClient, this.isUNCPath != false ? 1 : 0, this.timeOutInSeconds, this.guestOSUserName, this.guestOSPassword, this.uncPathUserName, this.uncPathPassword);
                AttemptStatus attemptStatus = super.executeVMOperation(string = vMUtilHandler.prepareVMOperationsXML(activityContext, this.vmName, this.vmGUID, this.vmClientName, VMOperationType.EXEC_GUEST_SCRIPT, this.virtualizationClient, "", true, string), activityContext);
                if (attemptStatus == AttemptStatus.SUCCESS && this.errCode != 0) {
                    String string5;
                    this.errorMessage = string5 = String.format("VM [%s] failed to Execute Script in Guest OS. Error[%s]", this.vmName, this.errMsg);
                    this.errorCode = this.errCode;
                    logger.error(string5);
                    activityContext.setFailureReason(string5);
                    return AttemptStatus.FAILED;
                }
                return attemptStatus;
            }
            String string6 = String.format("Unable to perform Execute Script in Guest OS Operation, some of the inputs are not specified. Hint: Please provide either VM ClientName or VM GUID & VM Name", new Object[0]);
            logger.error(string6);
            activityContext.setFailureReason(string6);
            return AttemptStatus.FAILED;
        }
        String string7 = String.format("Unable to perform Execute Script in Guest OS operation, virtualization client name is not provided", new Object[0]);
        logger.error(string7);
        activityContext.setFailureReason(string7);
        return AttemptStatus.FAILED;
    }
}

