/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.VMUtilities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.VMUtilities.VMOperationType;
import commvault.cte.workflow.activities.VMUtilities.VMOperationsHandler;
import commvault.cte.workflow.activities.VMUtilities.VMUtilHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;

public class CreateNetwork
extends VMOperationsHandler {
    private static final long serialVersionUID = 1L;
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateNetwork.class);
    @Input(documentation="The HostName or IP Address of ESX/Hyper-V Host, in case of cloud vendors it could be zone", required=true)
    public String HostName;
    @Input(documentation="The Virtual Network Switch Name", required=true)
    public String NetworkName;
    @Input(documentation="The Virutalization Client Name", required=true)
    public ClientEntity VirtualizationClient;
    @Output(documentation="return vm operations error code")
    public int errorCode;
    @Output(documentation="return vm operations error message")
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        String string = "";
        VMUtilHandler vMUtilHandler = new VMUtilHandler();
        if (this.HostName != null && this.HostName.length() > 0 && this.NetworkName != null && this.NetworkName.length() > 0 && this.VirtualizationClient != null && this.VirtualizationClient.getClientName().length() > 0) {
            string = vMUtilHandler.prepareNetworkOperationsXML(activityContext, VMOperationType.CREATE_NETWORK, this.HostName, this.NetworkName, this.VirtualizationClient);
            AttemptStatus attemptStatus = super.executeVMOperation(string, activityContext);
            if (attemptStatus == AttemptStatus.SUCCESS && this.errCode != 0) {
                String string2;
                this.errorMessage = string2 = String.format("Create Network [%s] Operation failed. Error[%s]", this.NetworkName, this.errMsg);
                this.errorCode = this.errCode;
                logger.error(string2);
                activityContext.setFailureReason(string2);
                return AttemptStatus.FAILED;
            }
            return attemptStatus;
        }
        String string3 = String.format("Unable to perform Create Network Operation, some of the inputs are not specified", new Object[0]);
        logger.error(string3);
        activityContext.setFailureReason(string3);
        return AttemptStatus.FAILED;
    }
}

