/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.VMUtilities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.VMUtilities.VMOperationType;
import commvault.cte.workflow.activities.VMUtilities.VMOperationsHandler;
import commvault.cte.workflow.activities.VMUtilities.VMUtilHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.EncryptedString;

public class CloneVM
extends VMOperationsHandler {
    private static final long serialVersionUID = -6638736003740912699L;
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CloneVM.class);
    @Input(documentation="The Virtual Machine Name", required=false)
    public String vmName;
    @Input(documentation="The Virtual Machine GUID", required=false)
    public String vmGUID;
    @Input(documentation="The Virtual Machine Client Name", required=false)
    public ClientEntity vmClient;
    @Input(documentation="The New Virtual Machine Name", required=true)
    public String newVMName;
    @Input(documentation="The user's password", required=true)
    public EncryptedString password;
    @Input(documentation="The Policy Name", required=true)
    public String policyName;
    @Input(documentation="The ESX/Hyper-v Host Name or IP Address", required=true)
    public String hostNameOrIPAddress;
    @Input(documentation="The Virtual Network Switch Name", required=false)
    public String networkName;
    @Output(documentation="The job id of the Clone request")
    public Integer jobID;
    @Output(documentation="return vm operations error code")
    public int errorCode;
    @Output(documentation="return vm operations error message")
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        String string = "";
        VMUtilHandler vMUtilHandler = new VMUtilHandler();
        if (this.isNotNullorEmpty(this.newVMName) && this.isNotNullorEmpty(this.hostNameOrIPAddress) && (this.isNotNullorEmpty(this.vmGUID) && this.isNotNullorEmpty(this.vmName) || this.vmClient != null)) {
            string = vMUtilHandler.prepareCloneVMTaskXML(activityContext, this.vmName, this.vmGUID, this.newVMName, this.vmClient, this.policyName, this.hostNameOrIPAddress, this.password.getPlainText(), VMOperationType.CLONE_VM, this.networkName);
            AttemptStatus attemptStatus = super.executeVMOperation(string, activityContext);
            if (attemptStatus == AttemptStatus.SUCCESS && this.errCode != 0) {
                String string2 = String.format("failed to clone VM [%s]. Error[%s]", this.vmName, this.errMsg);
                logger.error(string2);
                this.errorMessage = string2;
                this.errorCode = this.errCode;
                activityContext.setFailureReason(string2);
                return AttemptStatus.FAILED;
            }
            if (this.jobIDs != null && this.jobIDs.size() > 0) {
                this.jobID = Integer.parseInt((String)this.jobIDs.get(0));
            }
            return attemptStatus;
        }
        String string3 = String.format("Unable to perform  Clone VM Operation, some of the inputs are not specified. Hint: Please provide either VM ClientName or VM GUID & VM Name or ESX/Hyper-V HostName", new Object[0]);
        logger.error(string3);
        activityContext.setFailureReason(string3);
        return AttemptStatus.FAILED;
    }

    protected boolean isNotNullorEmpty(String string) {
        return string != null && string.length() > 0;
    }
}

