/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;

public class SwitchActivity
implements Activity,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SwitchActivity.class);
    @Input
    public String expression;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        return AttemptStatus.SUCCESS;
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs(), new DetermineTransition()};
    }

    private class DetermineTransition
    implements ProcessHandler {
        private DetermineTransition() {
        }

        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            logger.info(Long.valueOf(activityContext.getJobId()), "result of switch expression is [%s]", new Object[]{SwitchActivity.this.expression});
            if (activityContext.getOutboundTransitions().length == 0) {
                logger.info(Long.valueOf(activityContext.getJobId()), "no transitions to evaluate");
                return;
            }
            WorkflowTransition workflowTransition = null;
            if (SwitchActivity.this.expression == null) {
                SwitchActivity.this.expression = "";
            }
            for (WorkflowTransition workflowTransition2 : activityContext.getOutboundTransitions()) {
                if (workflowTransition2.getValue() != null && workflowTransition2.getValue().equalsIgnoreCase(SwitchActivity.this.expression)) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "taking transition [%s] because result [%s] matches inputed condition", new Object[]{workflowTransition2.getTargetActivity(), SwitchActivity.this.expression});
                    activityContext.addTransitionTo(workflowTransition2);
                    return;
                }
                if (workflowTransition2.getTransitionIndex() == 1) {
                    logger.debug(Long.valueOf(activityContext.getJobId()), "found default transition [%s]", new Object[]{workflowTransition2.getTargetActivity()});
                    workflowTransition = workflowTransition2;
                    continue;
                }
                logger.debug(Long.valueOf(activityContext.getJobId()), "skipping transition [%s] because value [%s] does not match [%s]", new Object[]{workflowTransition2.getTargetActivity(), workflowTransition2.getValue(), SwitchActivity.this.expression});
            }
            if (workflowTransition != null) {
                logger.info(Long.valueOf(activityContext.getJobId()), "taking default transition [%s] because no other transitions matched inputted condition", new Object[]{workflowTransition.getTargetActivity()});
                activityContext.addTransitionTo(workflowTransition);
            } else {
                logger.warn(Long.valueOf(activityContext.getJobId()), "could not determine conditional transition");
            }
        }
    }
}

