/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.AbstractHttpClientActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import workflow.types.EncryptedString;
import workflow.types.NameValue;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;

public class ServicenowLogin
extends AbstractHttpClientActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ServicenowLogin.class);
    @Input(required=true)
    public String username;
    @Input(required=true)
    public EncryptedString password;
    @Input(required=true)
    public String clientId;
    @Input(required=true)
    public EncryptedString clientSecret;
    @Input(required=true)
    public Boolean refreshTokenRequest;
    @InputOutput
    public String refreshToken;
    @InputOutput
    public String EndPointURL;
    @Output
    public String authToken;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.isEmptyString(this.refreshToken) && (this.isEmptyString(this.username) || this.password == null || this.isEmptyString(this.password.getPlainText()))) {
            logger.error("Either refresh token or username/password must be provided.");
            return AttemptStatus.FAILED;
        }
        WebRequest webRequest = new WebRequest();
        webRequest.setMethod(WebMethod.POST);
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        String string = "";
        if (this.refreshTokenRequest.booleanValue()) {
            string = "refresh_token";
            arrayList.add(new NameValue("refresh_token", this.refreshToken));
        } else {
            string = "password";
            arrayList.add(new NameValue("username", this.username));
            arrayList.add(new NameValue("password", this.password.getPlainText()));
        }
        arrayList.add(new NameValue("grant_type", string));
        arrayList.add(new NameValue("client_id", this.clientId));
        arrayList.add(new NameValue("client_secret", this.clientSecret.getPlainText()));
        webRequest.setPostParameters(arrayList);
        webRequest.setPostType(WebPostType.Form);
        logger.debug("sending request to server with : grant_type [" + string + "], client_id [" + this.clientId + "], client_secret [" + this.clientSecret.getPlainText() + "], username[" + this.username + "], password[" + this.password.getPlainText() + "]");
        webRequest.setUrl(this.EndPointURL + (this.EndPointURL.endsWith("/") ? "" : "/") + "oauth_token.do");
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                logger.error("Server return with message : " + this.output.toString());
                return AttemptStatus.FAILED;
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(this.output);
            this.authToken = jsonObject.get("access_token").getAsString();
            this.refreshToken = jsonObject.get("refresh_token").getAsString();
        }
        return AttemptStatus.SUCCESS;
    }

    public boolean isEmptyString(String string) {
        return string == null || string.trim() == "";
    }
}

