/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.AbstractHttpClientActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import workflow.types.NameValue;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;
import workflow.types.data.DataRow;
import workflow.types.data.DataSet;
import workflow.types.data.MetaData;

public class ServicenowFileUpload
extends AbstractHttpClientActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ServicenowFileUpload.class);
    @Input
    public String authToken;
    @Input
    public String tableName;
    @Input
    public String table_sys_id;
    @Input
    public String EndPointURL;
    @Input
    public String FilePath;
    @Output
    public String errorMessage;
    @Output
    public String errorDetail;
    @Output
    public DataSet rows;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        JsonObject jsonObject;
        logger.debug("Inside serivcenow execure method with context [" + activityContext.toString() + "]");
        this.errorMessage = null;
        this.errorDetail = null;
        File file = new File(this.FilePath);
        String string = this.EndPointURL + (this.EndPointURL.endsWith("/") ? "" : "/") + "api/now/attachment/file?table_name=" + this.tableName + "&table_sys_id=" + this.table_sys_id + "&file_name=" + file.getName();
        WebRequest webRequest = new WebRequest();
        webRequest.setMethod(WebMethod.POST);
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        arrayList.add(new NameValue("Accept", "application/json"));
        arrayList.add(new NameValue("Authorization", "Bearer " + this.authToken));
        arrayList.add(new NameValue("Content-Type", "multipart/form-data"));
        webRequest.setHeaders(arrayList);
        webRequest.setPostType(WebPostType.Raw);
        webRequest.setPostContentType("multipart/form-data");
        webRequest.setPostContent((Object)file);
        webRequest.setUrl(string);
        logger.debug("Seting Webrequest URL: [" + string + "] & body [" + webRequest.getPostContent().toString() + "]");
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        logger.debug("Webrequest Response Code: [" + this.statusCode + "] & Response Message: [" + this.output + "]");
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject2 = null;
        this.output = this.output.replace('\uffff', ' ');
        try {
            jsonObject2 = (JsonObject)jsonParser.parse(this.output != null ? this.output.trim() : "{'error':{'message':'No output received','detail':'No output received'}}");
        }
        catch (Exception exception) {
            logger.info("Failed while parsing json response string [" + this.output + "] with exception :\n\n" + exception.getMessage());
            jsonObject2 = null;
            this.errorMessage = "Error parsing json response";
            this.errorDetail = "Error parsing json response " + exception.getMessage();
        }
        if (jsonObject2 != null && (jsonObject = (JsonObject)jsonObject2.get("error")) != null) {
            this.errorMessage = jsonObject.get("message") + "";
            this.errorDetail = jsonObject.get("detail") + "";
        }
        Object object = jsonObject = jsonObject2 != null ? jsonObject2.get("result") : null;
        if (jsonObject != null) {
            this.setDataSet((JsonElement)jsonObject);
        } else {
            this.rows = new DataSet();
        }
        if (this.statusCode != 201) {
            return AttemptStatus.FAILED;
        }
        if (attemptStatus == AttemptStatus.SUCCESS || this.statusCode == 201) {
            return AttemptStatus.SUCCESS;
        }
        return AttemptStatus.SUCCESS;
    }

    public void setDataSet(JsonElement jsonElement) {
        this.rows = new DataSet();
        JsonObject jsonObject = (JsonObject)jsonElement;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (entry == null) continue;
            arrayList2.add(entry.getKey());
            arrayList.add(((JsonElement)entry.getValue()).isJsonNull() ? "" : ((JsonElement)entry.getValue()).getAsString());
        }
        this.rows.add(new DataRow(new MetaData(arrayList2.toArray(new String[0])), arrayList));
    }
}

