/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activities.AbstractHttpClientActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import workflow.types.NameValue;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;
import workflow.types.data.DataRow;
import workflow.types.data.DataSet;
import workflow.types.data.MetaData;

public abstract class ServicenowActivity
extends AbstractHttpClientActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ServicenowActivity.class);
    @Input
    public String authToken;
    @Input
    public String tableName;
    @Input
    public String EndPointURL;
    @Output
    public String errorMessage;
    @Output
    public String errorDetail;
    @Output
    public DataSet rows;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        JsonObject jsonObject;
        AttemptStatus attemptStatus;
        logger.debug("Inside serivcenow execure method with context [" + activityContext.toString() + "]");
        this.errorMessage = null;
        this.errorDetail = null;
        String string = this.getRowId();
        String string2 = this.EndPointURL + (this.EndPointURL.endsWith("/") ? "" : "/") + "api/now/table/" + this.getTableName() + (string == null || string.trim() == "" ? "" : "/" + string);
        WebMethod webMethod = this.getMethod();
        WebRequest webRequest = new WebRequest();
        webRequest.setMethod(webMethod);
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        arrayList.add(new NameValue("Accept", "application/json"));
        arrayList.add(new NameValue("Authorization", "Bearer " + this.authToken));
        arrayList.add(new NameValue("Content-Type", "application/json"));
        webRequest.setHeaders(arrayList);
        if (webMethod == WebMethod.POST || webMethod == WebMethod.PUT) {
            attemptStatus = this.getParameters();
            jsonObject = new JsonObject();
            for (NameValue nameValue : attemptStatus) {
                jsonObject.addProperty(nameValue.getName(), nameValue.getValue());
            }
            webRequest.setPostContentType("application/json");
            webRequest.setPostContent((Object)jsonObject.toString());
            webRequest.setPostType(WebPostType.Raw);
            string2 = string2 + "?sysparm_display_value=" + this.getDisplayValue() + "&sysparm_exclude_reference_link=" + this.getReferenceLink();
        } else if (webMethod == WebMethod.GET) {
            string2 = string2 + "?sysparm_display_value=" + this.getDisplayValue() + "&sysparm_exclude_reference_link=" + this.getReferenceLink() + "&sysparm_fields=" + this.getDisplayFields();
            if (string == null || string.trim() == "") {
                string2 = string2 + "&sysparm_limit=" + this.getDisplayLimit() + "&sysparm_query=" + this.getFilterQuery();
            }
        }
        webRequest.setUrl(string2);
        logger.debug("Seting Webrequest URL: [" + string2 + "] & body [" + webRequest.getPostContent().toString() + "]");
        attemptStatus = super.executeRequest(webRequest, activityContext);
        logger.debug("Webrequest Response Code: [" + this.statusCode + "] & Response Message: [" + this.output + "]");
        if (this.statusCode == 401) {
            logger.error("Failed request due to invalid credentials or expired token.");
            activityContext.setFailureReason(new EvMessageContainer("Failed request due to invalid credentials or expired token."));
            return AttemptStatus.FAILED;
        }
        if (attemptStatus == AttemptStatus.SUCCESS) {
            NameValue nameValue;
            jsonObject = new JsonParser();
            JsonObject jsonObject2 = null;
            this.output = this.output.replace('\uffff', ' ');
            try {
                jsonObject2 = (JsonObject)jsonObject.parse(this.output != null ? this.output.trim() : "{'error':{'message':'No output received','detail':'No output received'}}");
            }
            catch (Exception exception) {
                logger.info("Failed while parsing json response string [" + this.output + "] with exception :\n\n" + exception.getMessage());
                jsonObject2 = null;
                this.errorMessage = "Error parsing json response";
                this.errorDetail = "Error parsing json response " + exception.getMessage();
            }
            if (jsonObject2 != null && (nameValue = (JsonObject)jsonObject2.get("error")) != null) {
                this.errorMessage = nameValue.get("message").getAsString();
                this.errorDetail = nameValue.get("detail").getAsString();
            }
            JsonElement jsonElement = nameValue = jsonObject2 != null ? jsonObject2.get("result") : null;
            if (nameValue != null) {
                this.setDataSet((JsonElement)nameValue);
            } else {
                this.rows = new DataSet();
            }
        }
        return AttemptStatus.SUCCESS;
    }

    public abstract WebMethod getMethod();

    public String getTableName() {
        return this.tableName;
    }

    public String getRowId() {
        return null;
    }

    public List<NameValue> getParameters() {
        return null;
    }

    public String getDisplayLimit() {
        return "10";
    }

    public String getFilterQuery() {
        return "";
    }

    public String getDisplayValue() {
        return "true";
    }

    public String getReferenceLink() {
        return "true";
    }

    public String getDisplayFields() {
        return "";
    }

    public void setDataSet(JsonElement jsonElement) {
        this.rows = new DataSet();
        JsonObject jsonObject = (JsonObject)jsonElement;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (entry == null) continue;
            arrayList2.add(entry.getKey());
            arrayList.add(((JsonElement)entry.getValue()).isJsonNull() ? "" : ((JsonElement)entry.getValue()).getAsString());
        }
        this.rows.add(new DataRow(new MetaData(arrayList2.toArray(new String[0])), arrayList));
    }
}

