/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;
import workflow.types.Delimiter;
import workflow.types.data.DataRow;
import workflow.types.data.DataSet;

public class ResultSetToText
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ResultSetToText.class);
    @Input
    public Object resultSet;
    @Input(defaultValue="Comma")
    public Delimiter delimiter;
    @Input(defaultValue="false")
    public boolean headers;
    @Output
    public String output;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        int n;
        if (this.resultSet == null) {
            return AttemptStatus.SUCCESS;
        }
        DataSet dataSet = this.resultSet instanceof List ? (DataSet)((List)this.resultSet).get(0) : (DataSet)this.resultSet;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.headers) {
            for (n = 0; n < dataSet.getColumnCount(); ++n) {
                if (n > 0) {
                    stringBuffer.append(this.delimiter.getDelimiter());
                }
                stringBuffer.append(dataSet.getColumnName(n));
            }
            stringBuffer.append("\n");
        }
        for (n = 0; n < dataSet.getRowCount(); ++n) {
            if (n > 0) {
                stringBuffer.append("\n");
            }
            DataRow dataRow = (DataRow)dataSet.getRows().get(n);
            for (int i = 0; i < dataRow.getColumnCount(); ++i) {
                if (i > 0) {
                    stringBuffer.append(this.delimiter.getDelimiter());
                }
                if (dataRow.get(i) == null) {
                    stringBuffer.append("");
                    continue;
                }
                stringBuffer.append(String.valueOf(dataRow.get(i)));
            }
        }
        this.output = stringBuffer.toString();
        return AttemptStatus.SUCCESS;
    }
}

