/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import workflow.types.data.DataRow;
import workflow.types.data.DataSet;

public class ResultSetToHTML
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ResultSetToHTML.class);
    @Input
    public Object resultSet;
    @Input(defaultValue="false")
    public boolean headers;
    @Output
    public String output;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        int n;
        if (this.resultSet == null) {
            return AttemptStatus.SUCCESS;
        }
        DataSet dataSet = this.resultSet instanceof List ? (DataSet)((List)this.resultSet).get(0) : (DataSet)this.resultSet;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table border=\"1\">");
        if (this.headers) {
            stringBuffer.append("<tr>");
            for (n = 0; n < dataSet.getColumnCount(); ++n) {
                stringBuffer.append("<th cellpadding=\"5\">");
                stringBuffer.append(StringEscapeUtils.escapeHtml((String)dataSet.getColumnName(n)));
                stringBuffer.append("</th>");
            }
            stringBuffer.append("</tr>");
        }
        for (n = 0; n < dataSet.getRowCount(); ++n) {
            DataRow dataRow = (DataRow)dataSet.getRows().get(n);
            stringBuffer.append("<tr>");
            for (int i = 0; i < dataRow.getColumnCount(); ++i) {
                stringBuffer.append("<td cellpadding=\"5\">");
                if (dataRow.get(i) == null) {
                    stringBuffer.append("");
                } else {
                    stringBuffer.append(StringEscapeUtils.escapeHtml((String)String.valueOf(dataRow.get(i))));
                }
                stringBuffer.append("</td>");
            }
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        this.output = stringBuffer.toString();
        return AttemptStatus.SUCCESS;
    }
}

