/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.SuperProcess;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class ProcessBlockActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ProcessBlockActivity.class);

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        SuperProcess superProcess;
        WF_SuperProcess_t wF_SuperProcess_t;
        List list;
        try {
            list = activityContext.getDataAccess().getSuperProcesses(activityContext.getProcessStepId().intValue());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to select from table [WF_SuperProcess]", (Throwable)cTEDBException);
            activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            return AttemptStatus.FAILED;
        }
        if (list.size() > 0) {
            if (list.size() > 1) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "more then one super process row was found for ProcessStepId [%s]", new Object[]{activityContext.getProcessStepId()});
            } else {
                logger.debug(Long.valueOf(activityContext.getJobId()), "retrieved existing [WF_SuperProcess] record for ProcessStepId [%s]", new Object[]{activityContext.getProcessStepId()});
            }
            wF_SuperProcess_t = (WF_SuperProcess_t)list.get(0);
        } else {
            wF_SuperProcess_t = this.createSuperProcessRow(activityContext);
        }
        wF_SuperProcess_t.jobId.set(Long.valueOf(activityContext.getJobId()));
        try {
            superProcess = this.createSuperProcess(activityContext, wF_SuperProcess_t);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to load super process entry for process step id [" + activityContext.getProcessStepId() + "]", (Throwable)evFailureException);
            activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
            return AttemptStatus.FAILED;
        }
        if (superProcess.getExecutionState() == ExecutionState.COMPLETED) {
            logger.info(Long.valueOf(activityContext.getJobId()), "process block has already completed");
            return AttemptStatus.SUCCESS;
        }
        try {
            wF_SuperProcess_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error saving super process", (Throwable)cTEDBException);
            activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            return AttemptStatus.FAILED;
        }
        SuperProcessManager superProcessManager = new SuperProcessManager((ProcessContext)superProcess);
        superProcessManager.worker();
        if (activityContext.getStatus() == ProcessStatus.RUNNING && superProcessManager.getSize() == 0) {
            superProcess.complete();
        } else if (activityContext.getStatus() == ProcessStatus.SUSPEND_PENDING || activityContext.getStatus() == ProcessStatus.SUSPENDED) {
            activityContext.setStatus(ProcessStatus.SUSPENDED);
            activityContext.setCurrentPhase(-1);
        } else {
            logger.debug(Long.valueOf(activityContext.getJobId()), "process block is exiting with status [%s], step count [%s]", new Object[]{activityContext.getStatus().toString(), superProcessManager.getSize()});
            activityContext.repeat(Integer.valueOf(0));
        }
        return AttemptStatus.SUCCESS;
    }

    protected WF_SuperProcess_t createSuperProcessRow(ActivityContext activityContext) {
        logger.debug(Long.valueOf(activityContext.getJobId()), "creating new [WF_SuperProcess] record for ProcessStepId [%s], data access class [%s]", new Object[]{activityContext.getProcessStepId(), activityContext.getDataAccess().getClass()});
        WF_SuperProcess_t wF_SuperProcess_t = activityContext.getDataAccess().newSuperProcess();
        wF_SuperProcess_t.ProcessStepId.set(activityContext.getProcessStepId());
        wF_SuperProcess_t.State.set(Integer.valueOf(ExecutionState.STARTING.toInt()));
        wF_SuperProcess_t.Started.set(Integer.valueOf(DateUtilities.getNow()));
        wF_SuperProcess_t.jobId.set(Long.valueOf(activityContext.getJobId()));
        return wF_SuperProcess_t;
    }

    protected SuperProcess createSuperProcess(ActivityContext activityContext, WF_SuperProcess_t wF_SuperProcess_t) throws EvFailureException {
        return new SuperProcess(activityContext, wF_SuperProcess_t);
    }

    private class SuperProcessManager
    extends ProcessManager {
        public SuperProcessManager(ProcessContext processContext) {
            super(processContext);
        }

        protected void worker() {
            super.worker();
        }
    }
}

