/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activities.CommandActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import workflow.types.EncryptedString;

public class PSExecActivity
extends CommandActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(PSExecActivity.class);
    private static final Map<Integer, String> EXIT_CODE_MESSAGES = new HashMap<Integer, String>();
    @Input
    public String hostName;
    @Input
    public String userName;
    @Input
    public EncryptedString password;
    @Input(defaultValue="false", documentation="uses the supplied credentials for executing the paexec command locally")
    public Boolean useImpersonation;
    @Input
    public String additionalParameters = "";
    @Input
    public String program;
    @Input
    public String arguments;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        boolean bl = System.getProperty("os.name").startsWith("Windows");
        if (!bl) {
            this.errorCode = 1;
            logger.error(Long.valueOf(activityContext.getJobId()), "psexec activity only runs on windows");
            activityContext.setFailureReason("psexec activity only runs on windows");
            return AttemptStatus.FAILED;
        }
        if (this.hostName == null || this.hostName.length() == 0) {
            this.errorCode = 1;
            logger.error(Long.valueOf(activityContext.getJobId()), "activity is missing required hostName input");
            activityContext.setFailureReason("missing required hostName input");
            return AttemptStatus.FAILED;
        }
        this.hostName = this.hostName.trim();
        if (this.hostName.toLowerCase().indexOf(" ") > -1) {
            this.errorCode = 1;
            logger.error(Long.valueOf(activityContext.getJobId()), "illegal character found in host name");
            activityContext.setFailureReason("illegal character found in host name");
            return AttemptStatus.FAILED;
        }
        if (this.userName == null || this.userName.length() == 0) {
            this.errorCode = 1;
            logger.error(Long.valueOf(activityContext.getJobId()), "activity is missing required userName input");
            activityContext.setFailureReason("missing required username input");
            return AttemptStatus.FAILED;
        }
        if (this.password == null) {
            this.errorCode = 1;
            logger.error(Long.valueOf(activityContext.getJobId()), "activity is missing required password input");
            activityContext.setFailureReason("missing required password input");
            return AttemptStatus.FAILED;
        }
        if (this.useImpersonation == null) {
            this.useImpersonation = false;
        }
        File file = new File(WorkflowRegistry.getInstance().getInstallFolder(), "psexec64.exe");
        File file2 = new File(WorkflowRegistry.getInstance().getInstallFolder(), "psexec.exe");
        File file3 = new File(WorkflowRegistry.getInstance().getInstallFolder(), "paexec.exe");
        if (file.exists()) {
            return this.executePSExec(file, activityContext);
        }
        if (file2.exists()) {
            return this.executePSExec(file2, activityContext);
        }
        if (file3.exists()) {
            return this.executePAExec(file3, activityContext);
        }
        this.errorCode = 1;
        logger.error(Long.valueOf(activityContext.getJobId()), "could not find psexec executable in the folder [" + WorkflowRegistry.getInstance().getInstallFolder() + "]");
        activityContext.setFailureReason("psexec executable not found");
        return AttemptStatus.FAILED;
    }

    public AttemptStatus executePSExec(File file, ActivityContext activityContext) throws InterruptedException {
        String string = this.password.getPlainText();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/C \"\"");
        stringBuffer.append(file);
        stringBuffer.append("\" \\\\");
        stringBuffer.append(this.hostName);
        stringBuffer.append(" -u \"" + this.userName + "\"");
        stringBuffer.append(" -p \"" + string + "\"");
        if (this.additionalParameters != null && this.additionalParameters.length() > 0) {
            stringBuffer.append(" " + this.additionalParameters);
        }
        stringBuffer.append(" \"" + this.program + "\" ");
        stringBuffer.append(this.arguments);
        stringBuffer.append("\"");
        String string2 = null;
        EncryptedString encryptedString = null;
        if (this.useImpersonation.booleanValue()) {
            string2 = this.userName;
            encryptedString = this.password;
        }
        String string3 = "executing command [" + this.program + "] on machine [" + this.hostName + "] as user [" + this.userName + "]";
        try {
            return this.executeCommand(activityContext, WorkflowProperties.getInstance().getClient().getClientName(), string2, encryptedString, "", "cmd.exe", "", null, stringBuffer.toString(), true, string3, string, null);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
    }

    public AttemptStatus executePAExec(File file, ActivityContext activityContext) throws InterruptedException {
        String string;
        String string2 = this.password.getPlainText();
        File file2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/C \"\"");
        stringBuffer.append(file);
        stringBuffer.append("\" \\\\");
        stringBuffer.append(this.hostName);
        stringBuffer.append(" -u \"" + this.userName + "\"");
        stringBuffer.append(" -p \"" + string2 + "\"");
        if (this.additionalParameters != null && this.additionalParameters.length() > 0) {
            stringBuffer.append(" " + this.additionalParameters);
        }
        if (activityContext.getTimeout() > 0) {
            stringBuffer.append(" -to " + activityContext.getTimeout() * 60);
        }
        if (logger.isDebug()) {
            string = UUID.randomUUID().toString() + ".log";
            logger.debug(Long.valueOf(activityContext.getJobId()), "creating file [%s] for paexec logging", new Object[]{string});
            file2 = new File(WorkflowRegistry.getInstance().getGalaxyTempDir(), string);
            stringBuffer.append(" -lo \"" + file2.getAbsolutePath() + "\"");
        }
        stringBuffer.append(" \"" + this.program + "\" ");
        stringBuffer.append(this.arguments);
        stringBuffer.append("\"");
        string = null;
        EncryptedString encryptedString = null;
        if (this.useImpersonation.booleanValue()) {
            string = this.userName;
            encryptedString = this.password;
        }
        String string3 = "executing command [" + this.program + "] on machine [" + this.hostName + "] as user [" + this.userName + "]";
        try {
            return this.executeCommand(activityContext, WorkflowProperties.getInstance().getClient().getClientName(), string, encryptedString, "", "cmd.exe", "", null, stringBuffer.toString(), true, string3, string2, EXIT_CODE_MESSAGES);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
    }

    public void setAdditionalParameters(String string) {
        this.additionalParameters = string;
    }

    static {
        EXIT_CODE_MESSAGES.put(-1, "internal error");
        EXIT_CODE_MESSAGES.put(-2, "command line error");
        EXIT_CODE_MESSAGES.put(-3, "failed to launch app (locally)");
        EXIT_CODE_MESSAGES.put(-4, "failed to copy PAExec to remote (connection to ADMIN$ might have failed)");
        EXIT_CODE_MESSAGES.put(-5, "connection to server taking too long (timeout)");
        EXIT_CODE_MESSAGES.put(-6, "PAExec service could not be installed/started on remote server");
        EXIT_CODE_MESSAGES.put(-7, "could not communicate with remote PAExec service");
        EXIT_CODE_MESSAGES.put(-8, "failed to copy app to remote server");
        EXIT_CODE_MESSAGES.put(-9, "failed to launch app (remotely)");
        EXIT_CODE_MESSAGES.put(-10, "app was terminated after timeout expired");
        EXIT_CODE_MESSAGES.put(-11, "forcibly stopped with Ctrl-C / Ctrl-Break");
    }
}

