/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.StatusEventManager;
import commvault.cte.workflow.SuperProcess;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.DetermineTransitions;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class OnWorkflowCompleteActivity
implements Activity,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OnWorkflowCompleteActivity.class);

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        SuperProcess superProcess;
        WF_SuperProcess_t wF_SuperProcess_t;
        List list;
        try {
            list = activityContext.getDataAccess().getSuperProcesses(activityContext.getProcessStepId().intValue(), ExecutionState.RUNNING);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve executing super processes for step id [" + activityContext.getProcessStepId() + "]", (Throwable)cTEDBException);
            activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            return AttemptStatus.FAILED;
        }
        if (list.size() > 0) {
            wF_SuperProcess_t = (WF_SuperProcess_t)list.get(0);
        } else {
            wF_SuperProcess_t = activityContext.getDataAccess().newSuperProcess();
            wF_SuperProcess_t.ProcessStepId.set(activityContext.getProcessStepId());
            wF_SuperProcess_t.State.set(Integer.valueOf(ExecutionState.STARTING.toInt()));
            wF_SuperProcess_t.Started.set(Integer.valueOf(DateUtilities.getNow()));
        }
        wF_SuperProcess_t.jobId.set(Long.valueOf(activityContext.getJobId()));
        try {
            superProcess = new SuperProcess(activityContext, wF_SuperProcess_t);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to load super process entry for process step id [" + activityContext.getProcessStepId() + "]", (Throwable)evFailureException);
            activityContext.setFailureReason(new EvMessageContainer(evFailureException.getMessage()));
            return AttemptStatus.FAILED;
        }
        try {
            wF_SuperProcess_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error saving super process", (Throwable)cTEDBException);
            activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            return AttemptStatus.FAILED;
        }
        StatusEventManager statusEventManager = new StatusEventManager((ProcessContext)superProcess);
        statusEventManager.worker();
        if (activityContext.getStatus() == ProcessStatus.RUNNING) {
            superProcess.complete();
        } else if (activityContext.getStatus() == ProcessStatus.SUSPEND_PENDING || activityContext.getStatus() == ProcessStatus.SUSPENDED) {
            activityContext.setStatus(ProcessStatus.SUSPENDED);
            activityContext.setCurrentPhase(-1);
        }
        return AttemptStatus.SUCCESS;
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new DetermineTransitions()};
    }
}

