/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.XMLOutput;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.util.ArrayList;
import java.util.List;
import workflow.types.SimpleType;
import workflow.types.XPathOutput;

public class MultiXPathActivity
implements Activity,
XMLOutput {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(MultiXPathActivity.class);
    @Input(documentation="the xml blob to perform the query on")
    public String xml;
    @Input
    public List<XPathOutput> xpaths;
    private String output;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        List list;
        if (this.xml == null || this.xml.length() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "xml input parameter into activity is null");
            return AttemptStatus.SUCCESS;
        }
        if (this.xpaths == null || this.xpaths.size() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "no xpath statements provided to activity");
            return AttemptStatus.SUCCESS;
        }
        ArrayList<XPathResult> arrayList = new ArrayList<XPathResult>();
        for (XPathOutput object : this.xpaths) {
            if (object.getOutputName() == null || object.getOutputName().length() == 0) {
                logger.info(Long.valueOf(activityContext.getJobId()), "invalid xpath statement defined in inputs");
                continue;
            }
            if (object.getXpath() == null || object.getXpath().length() == 0) {
                logger.info(Long.valueOf(activityContext.getJobId()), "xpath input parameter into activity is null for [" + object.getOutputName() + "]");
                continue;
            }
            boolean bl = object.getOutputAsList() == null ? true : object.getOutputAsList();
            list = object.getOutputType() == null ? SimpleType.String : object.getOutputType();
            XPathResult xPathResult = new XPathResult(object.getOutputName());
            try {
                xPathResult.value = XMLQuery.query((String)this.xml, (String)object.getXpath(), (SimpleType)list, (boolean)bl);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            if (xPathResult.value == null) continue;
            arrayList.add(xPathResult);
        }
        WorkflowElement workflowElement = new WorkflowElement("outputs");
        try {
            for (XPathResult xPathResult : arrayList) {
                list = activityContext.getMarshaller().encode(xPathResult.output, xPathResult.value);
                workflowElement.addContent(list);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        this.output = workflowElement.toString();
        return AttemptStatus.SUCCESS;
    }

    public String getOutputs() {
        return this.output;
    }

    private static class XPathResult {
        private String output;
        private Object value;

        private XPathResult(String string) {
            this.output = string;
        }
    }
}

