/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowLock;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.PreparedStatement;

public class LockReleaseActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(LockReleaseActivity.class);
    private static final String DELETE_LOCK_QUERY = "DELETE FROM WF_Lock WHERE name = ? AND jobId = ?";
    @InputOutput(documentation="the name of the lock you want to release")
    public String name;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        try {
            if (activityContext.isGlobalLock()) {
                if (this.deleteLock(activityContext)) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "released lock for name [%s]", new Object[]{this.name});
                } else {
                    logger.warn("could not find lock entry to remove for name [" + this.name + "] and job id [" + activityContext.getJobId() + "]");
                }
            } else {
                WorkflowLock.getInstance().releaseLock(activityContext, this.name);
                logger.info(Long.valueOf(activityContext.getJobId()), "released lock for name [%s]", new Object[]{this.name});
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private boolean deleteLock(ActivityContext activityContext) throws EvFailureException {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(DELETE_LOCK_QUERY);
            preparedStatement.setString(1, this.name);
            preparedStatement.setInt(2, Long.valueOf(activityContext.getJobId()).intValue());
            boolean bl = preparedStatement.executeUpdate() > 0;
            return bl;
        }
    }
}

