/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowLock;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;

public class LockAcquireActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(LockAcquireActivity.class);
    private static final String GAIN_LOCK_QUERY = "SET NOCOUNT ON \nDECLARE @name nvarchar(255) = ? \nDECLARE @stepId int = ? \nDECLARE @jobId int = ? \nDECLARE @clientId int = ? \nIF EXISTS(Select stepId From WF_Lock Where name = @name) \n   SELECT clientId, stepId From WF_Lock Where name = @name \nELSE \nBEGIN \n   INSERT INTO WF_Lock(stepId,jobId,apiId,name,clientId,createdTime) \n   VALUES (@stepId,@jobId,'',@name,@clientId,dbo.GetUnixTime(GETUTCDATE())) \n   SELECT @clientId As clientId, @stepId As stepId \nEND \n";
    private static long SLEEP_TIME = 10000L;
    @InputOutput(documentation="the name you want to lock on")
    public String name;
    @Input(defaultValue="true", documentation="releases the lock automatically when the workflow completes")
    public Boolean releaseLockOnCompletion;
    @Input(documentation="timeout in minutes for trying to acquire the lock")
    public Integer timeout;
    @Output
    public boolean lockAquired;
    private boolean globalLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        this.lockAquired = false;
        this.globalLock = activityContext.isGlobalLock();
        if (this.globalLock && activityContext.getJobId() == 0L) {
            logger.error("cannot aquire locks for jobs with no job id");
            activityContext.setFailureReason(new EvMessageContainer("cannot aquire locks for jobs with no job id"));
            return AttemptStatus.FAILED;
        }
        logger.info("acquiring lock on [" + this.name + "]");
        activityContext.setStatus(ProcessStatus.WAITING);
        activityContext.setFailureReason("waiting to acquire lock [%s]", new Object[]{this.name});
        activityContext.getJobManager().updatePendingReason();
        boolean bl = this.timeout != null;
        long l = Calendar.getInstance().getTimeInMillis();
        while (true) {
            Object object = activityContext.getLock();
            synchronized (object) {
                if (this.globalLock) {
                    if (this.gainLock(activityContext)) {
                        this.lockAquired = true;
                        logger.info(Long.valueOf(activityContext.getJobId()), "retrieved lock for name [%s]", new Object[]{this.name});
                        return AttemptStatus.SUCCESS;
                    }
                } else {
                    try {
                        if (WorkflowLock.getInstance().aquireLock(activityContext, this.name, this.releaseLockOnCompletion.booleanValue())) {
                            this.lockAquired = true;
                            logger.info(Long.valueOf(activityContext.getJobId()), "retrieved lock for name [%s]", new Object[]{this.name});
                            return AttemptStatus.SUCCESS;
                        }
                    }
                    catch (EvFailureException evFailureException) {
                        activityContext.setFailureReason(evFailureException.getMessageContainer());
                        return AttemptStatus.FAILED;
                    }
                }
                if (bl) {
                    long l2 = (Calendar.getInstance().getTimeInMillis() - l) / 60000L;
                    if (this.timeout == 0 || l2 >= (long)this.timeout.intValue()) {
                        logger.warn(Long.valueOf(activityContext.getJobId()), "failing activity since acquire time has exceeded timeout value [%s]", new Object[]{this.timeout});
                        return AttemptStatus.FAILED;
                    }
                }
                if (activityContext.getStatus() != ProcessStatus.WAITING) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since it has a status of [%s]", new Object[]{activityContext.getStatus()});
                    activityContext.repeat(Integer.valueOf(0));
                    return AttemptStatus.SUCCESS;
                }
                if (!activityContext.isRunning()) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since the workflow engine is shutting down");
                    activityContext.repeat(Integer.valueOf(0));
                    return AttemptStatus.SUCCESS;
                }
                activityContext.getLock().wait(SLEEP_TIME);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean gainLock(ActivityContext activityContext) {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(GAIN_LOCK_QUERY);
            preparedStatement.setString(1, this.name);
            preparedStatement.setInt(2, activityContext.getProcessStepId());
            preparedStatement.setInt(3, Long.valueOf(activityContext.getJobId()).intValue());
            preparedStatement.setInt(4, WorkflowProperties.getInstance().getClient().getClientId());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                if (resultSet.getInt("clientId") == WorkflowProperties.getInstance().getClient().getClientId() && resultSet.getInt("stepId") == activityContext.getProcessStepId().intValue()) {
                    logger.info("successfully gained lock on [" + this.name + "]");
                    boolean bl = true;
                    return bl;
                }
                logger.debug("lock is currently held by step id [" + resultSet.getInt("stepId") + "] on client [" + resultSet.getInt("clientId") + "]");
                boolean bl = false;
                return bl;
            }
            logger.error("no result returned from query [SET NOCOUNT ON \nDECLARE @name nvarchar(255) = ? \nDECLARE @stepId int = ? \nDECLARE @jobId int = ? \nDECLARE @clientId int = ? \nIF EXISTS(Select stepId From WF_Lock Where name = @name) \n   SELECT clientId, stepId From WF_Lock Where name = @name \nELSE \nBEGIN \n   INSERT INTO WF_Lock(stepId,jobId,apiId,name,clientId,createdTime) \n   VALUES (@stepId,@jobId,'',@name,@clientId,dbo.GetUnixTime(GETUTCDATE())) \n   SELECT @clientId As clientId, @stepId As stepId \nEND \n]");
        }
        return false;
    }
}

