/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.ListItemActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import java.util.Arrays;
import java.util.List;

public class ListActivityAdd
extends ListItemActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListActivityAdd.class);
    @Input
    public String addToList;
    @Input
    public Object itemToAdd;
    @Output
    public Boolean added;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object = activityContext.getWorkflowExecution().getLock();
        synchronized (object) {
            List list;
            this.added = true;
            if (this.addToList == null || this.addToList.length() == 0) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "list input is empty");
                this.added = false;
                return AttemptStatus.SUCCESS;
            }
            if (this.itemToAdd == null || this.itemToAdd.toString().length() == 0) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "item input is empty");
                this.added = false;
                return AttemptStatus.SUCCESS;
            }
            try {
                this.decodeList(activityContext, this.addToList);
                this.decodeItem(activityContext, this.itemToAdd, true);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                this.added = false;
                return AttemptStatus.FAILED;
            }
            if (this.itemObject == null) {
                logger.info(Long.valueOf(activityContext.getJobId()), "item input expression [%s] returned a null object", new Object[]{this.addToList});
                this.added = false;
                return AttemptStatus.SUCCESS;
            }
            if (this.listElements.size() == 1 && ((WorkflowElement)this.listElements.get(0)).getText().length() == 0) {
                logger.debug(Long.valueOf(activityContext.getJobId()), "removing blank list item");
                this.parent.removeContent((WorkflowElement)this.listElements.get(0));
            }
            try {
                if (this.itemObject instanceof List) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "adding all items %s to list [%s]", new Object[]{this.itemObject, this.addToList});
                    list = activityContext.getMarshaller().encode(this.listName, this.itemObject);
                } else {
                    logger.info(Long.valueOf(activityContext.getJobId()), "adding item [%s] to list [%s]", new Object[]{this.itemObject, this.addToList});
                    list = activityContext.getMarshaller().encode(this.listName, Arrays.asList(this.itemObject));
                }
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                this.added = false;
                return AttemptStatus.FAILED;
            }
            this.parent.addContent(list);
        }
        return AttemptStatus.SUCCESS;
    }
}

