/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.List;

public abstract class ListActivity
implements Activity,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListActivity.class);
    protected List<WorkflowElement> listElements;
    protected WorkflowElement parent;
    protected String listName;
    protected List listObject;
    protected Class type;

    protected void decodeList(ActivityContext activityContext, String string) throws EvFailureException {
        if (string.matches("(?i)xpath:\\{[\\S\\s]*}")) {
            string = ExpressionUtils.getExpression((String)string);
        }
        try {
            this.listElements = activityContext.getWorkflowExecution().select(string);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [" + string + "]", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (this.listElements == null || this.listElements.size() == 0) {
            this.decodeNewList(activityContext, string);
            return;
        }
        this.parent = this.listElements.get(0).getParent();
        this.listName = this.listElements.get(0).getName();
        logger.debug(Long.valueOf(activityContext.getJobId()), "retrieving list name [%s] under parent element [%s]", new Object[]{this.listName, this.parent.getName()});
        this.listObject = activityContext.getMarshaller().decodeList(this.listElements);
        if (this.listObject == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "null object was return for expression [" + string + "]");
            throw new EvFailureException(new EvMessageContainer("null object was return for expression [%s]", new Object[]{string}));
        }
        this.type = this.listObject.size() > 0 && this.listObject.get(0) != null ? this.listObject.get(0).getClass() : activityContext.getWorkflowExecution().getElementClass(this.listElements.get(0));
        logger.debug(Long.valueOf(activityContext.getJobId()), "list item type [%s]", new Object[]{this.type});
    }

    private void decodeNewList(ActivityContext activityContext, String string) throws EvFailureException {
        String[] stringArray;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((stringArray = string.split("/")).length != 3) {
            logger.error(Long.valueOf(activityContext.getJobId()), "unknown list path [" + string + "]");
            throw new EvFailureException(new EvMessageContainer("unknown list path [" + string + "]"));
        }
        if (stringArray[1].equals("variables")) {
            this.parent = activityContext.getWorkflowExecution().getVariables();
        } else if (stringArray[1].equals("inputs")) {
            this.parent = activityContext.getWorkflowExecution().getInputs();
        } else {
            logger.error(Long.valueOf(activityContext.getJobId()), "unable to retrieve list [" + string + "]");
            throw new EvFailureException(new EvMessageContainer("unable to retrieve list [" + string + "]"));
        }
        this.listObject = new ArrayList();
        this.listName = stringArray[2];
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) {
    }
}

