/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class IsRequestSigned
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(IsRequestSigned.class);
    @Input
    public String request;
    @Output
    public Boolean signed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.request == null || this.request.equals("")) {
            logger.info(Long.valueOf(activityContext.getJobId()), "Null or empty request xml.");
            return AttemptStatus.SUCCESS;
        }
        WorkflowElement workflowElement = null;
        WorkflowElement workflowElement2 = null;
        CTEDBReservation cTEDBReservation = null;
        CTEDBReservation cTEDBReservation2 = null;
        String string = "";
        try {
            workflowElement = WorkflowElement.parse((String)this.request);
            workflowElement2 = workflowElement.getChild("processinginstructioninfo");
            if (workflowElement2 != null) {
                String string2;
                Object object;
                for (Object object2 : workflowElement2.getChildren()) {
                    object = object2.getAttributeValue("name");
                    string2 = object2.getAttributeValue("value");
                    if (object == null || !((String)object).equals("authCode") || string2 == null) continue;
                    string = string2;
                    break;
                }
                if (string != null && !string.equals("")) {
                    Object object2;
                    logger.info(Long.valueOf(activityContext.getJobId()), "Validating authcode[%s]", new Object[]{string});
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("SELECT 1 FROM APP_BLAuthorizationCode WHERE authCode = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                    cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();
                    object2 = cTEDBReservation.createStatement(stringBuffer.toString());
                    object = object2.executeQuery();
                    if (object.next()) {
                        string2 = object.getString(1);
                        if (string2 != null && string2.equals("1")) {
                            logger.info(Long.valueOf(activityContext.getJobId()), "Authcode is valid.");
                            this.signed = true;
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer2.append("DELETE APP_BLAuthorizationCode WHERE authCode = '");
                            stringBuffer2.append(string);
                            stringBuffer2.append("'");
                            cTEDBReservation2 = WorkflowProperties.getInstance().getCommCellConnection().createReservation();
                            PreparedStatement preparedStatement = cTEDBReservation2.createStatement(stringBuffer2.toString());
                            preparedStatement.executeUpdate();
                        } else {
                            logger.info(Long.valueOf(activityContext.getJobId()), "Authcode is invalid.");
                        }
                    } else {
                        logger.info(Long.valueOf(activityContext.getJobId()), "Invalid Authcode.");
                    }
                } else {
                    logger.info(Long.valueOf(activityContext.getJobId()), "Authcode not available in request xml.");
                }
            } else {
                logger.info(Long.valueOf(activityContext.getJobId()), "Processing instruction not available in request xml.");
            }
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "Error parsing XML [" + this.request + "]");
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "database exception", (Throwable)cTEDBException);
        }
        catch (SQLException sQLException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "database exception", (Throwable)sQLException);
        }
        finally {
            if (cTEDBReservation != null) {
                cTEDBReservation.close();
            }
            if (cTEDBReservation2 != null) {
                cTEDBReservation2.close();
            }
        }
        return AttemptStatus.SUCCESS;
    }
}

