/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.InteractiveBaseActivity;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.InformationalMessageResponse;
import commvault.msgs.Workflow.InputAction;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.InteractiveResponse;
import commvault.msgs.Workflow.MessageDialogType;
import commvault.msgs.Workflow.MessageIconType;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang.StringEscapeUtils;

public class InteractiveMessageActivity
extends InteractiveBaseActivity
implements ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InteractiveMessageActivity.class);
    @Input
    public String message;
    @Input
    public Boolean html;
    @Input
    public MessageDialogType dialogType;
    @Input
    public MessageIconType iconType;
    @Input
    public String title;
    @Input
    public List<InputAction> actions;
    @Input
    public String formProperties;
    @Output
    public String actionSelected;

    @Override
    public InteractiveResponse getResponse(ActivityContext activityContext) {
        if (this.html == null) {
            this.html = false;
        }
        if (this.message == null) {
            this.message = "";
        }
        if (this.dialogType == null) {
            this.dialogType = MessageDialogType.Popup;
        }
        if (this.iconType == null) {
            this.iconType = MessageIconType.Information;
        }
        if (!this.html.booleanValue()) {
            this.message = this.string2Html(this.message);
        }
        InformationalMessageResponse informationalMessageResponse = new InformationalMessageResponse();
        informationalMessageResponse.setMessage(this.message);
        informationalMessageResponse.setHtml(this.html.booleanValue());
        informationalMessageResponse.setDialogType(this.dialogType);
        informationalMessageResponse.setIconType(this.iconType);
        informationalMessageResponse.setTitle(this.title);
        informationalMessageResponse.setActions(this.actions);
        try {
            informationalMessageResponse.setProperties(WorkflowUtils.getFormProperties((ActivityContext)activityContext, (String)this.formProperties));
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error building form properties");
        }
        return informationalMessageResponse;
    }

    private String string2Html(String string) {
        string = StringEscapeUtils.escapeHtml((String)string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        Scanner scanner = new Scanner(string);
        while (scanner.hasNextLine()) {
            stringBuffer.append(scanner.nextLine());
            stringBuffer.append("<br>");
        }
        scanner.close();
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    @Override
    public AttemptStatus processRequest(InteractiveRequest interactiveRequest, ActivityContext activityContext) throws EvFailureException {
        this.actionSelected = interactiveRequest.getAction();
        return AttemptStatus.SUCCESS;
    }

    @Override
    public String getPendingReason(ActivityContext activityContext) {
        return String.format("waiting on user informational action", new Object[0]);
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
        logger.debug(Long.valueOf(activityContext.getJobId()), "begin processing expressions for inputs into activity [%s], xml [%s]", new Object[]{activityContext.getFriendlyName(), workflowElement.toString()});
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        for (WorkflowElement workflowElement2 : workflowElement.getChildren()) {
            if (workflowElement2.getName().equalsIgnoreCase("formProperties")) continue;
            workflowEvaluator.processChildElement(workflowElement2);
        }
    }
}

