/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.activities.InteractiveEndSessionActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.XMLInput;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestManager;
import commvault.cte.workflow.utils.OutputBuilder;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.Workflow.EndUserSessionResponse;
import commvault.msgs.Workflow.InteractiveResponse;

public class InteractiveEndSessionOutputsActivity
implements Activity,
XMLInput {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InteractiveEndSessionActivity.class);
    private String inputs;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WorkflowElement workflowElement;
        logger.info(Long.valueOf(activityContext.getJobId()), "marking the interactive session for workflow [%s] as completed", new Object[]{activityContext.getWorkflowName()});
        try {
            workflowElement = WorkflowElement.parse((String)this.inputs);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        workflowElement.setName("outputs");
        EndUserSessionResponse endUserSessionResponse = new EndUserSessionResponse();
        try {
            endUserSessionResponse.setOutputs(OutputBuilder.buildOutputs((ProcessContext)activityContext.getParent(), (WorkflowElement)workflowElement, (XMLSchema)activityContext.getSchema().getOutputs(), (boolean)false));
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build outputs");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        RequestManager.populateInteractiveResponse((InteractiveResponse)endUserSessionResponse, (WorkflowContext)activityContext);
        if (!activityContext.isDebug()) {
            SessionManager.getInstance().close(activityContext.getSessionId(), (CTEProcessingModel)endUserSessionResponse);
        } else {
            logger.info("skip closing session since we are in debug mode, outputs [%s]", new Object[]{workflowElement.toString()});
        }
        return AttemptStatus.SUCCESS;
    }

    public void setInputs(String string) {
        this.inputs = string;
    }
}

