/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.ExecuteCommand;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.db.GenericQuery;
import commvault.cte.workflow.db.WorkflowConnection;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;
import workflow.types.DatabaseType;
import workflow.types.EncryptedString;
import workflow.types.SQLParameter;
import workflow.types.data.DataSet;

public class GenercicDBQuery
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ExecuteCommand.class);
    @Input(documentation="the type of database", defaultValue="MSSQL")
    public DatabaseType databaseType;
    @Input(documentation="the server and instance to connect to (i.e. dbserver\\dbinstance")
    public String server;
    @Input(documentation="the name of the database to connect to")
    public String databaseName;
    @Input(documentation="allows for additional properties added to the JDBC url")
    public String properties;
    @Input(documentation="the username to connect to the database")
    public String userName;
    @Input(documentation="the password to connect to the database")
    public EncryptedString password;
    @Input(documentation="the sql query to execute on the database")
    public String query;
    @Input(visible=false)
    public List<SQLParameter> parameters;
    @Output
    public List<DataSet> resultSets;
    @Output
    public int errorCode;
    @Output
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        String string;
        String string2;
        int n;
        this.errorCode = 0;
        this.errorMessage = "";
        if (this.query == null || this.query.length() == 0) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "no query to execute");
            return AttemptStatus.SUCCESS;
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseType.MSSQL;
        }
        if ((n = this.userName.indexOf(92)) > -1) {
            string2 = this.userName.substring(0, n);
            this.userName = this.userName.substring(n + 1);
            String string3 = null;
            n = this.server.indexOf(92);
            if (n > -1) {
                string3 = this.server.substring(n + 1);
                this.server = this.server.substring(0, n);
            }
            string = String.format("jdbc:jtds:sqlserver://%s/%s;useNTLMv2=true;domain=%s", this.server, this.databaseName, string2);
            if (string3 != null) {
                string = string + String.format(";instance=%s", string3);
            }
        } else {
            string = WorkflowConnection.getDatabaseURL((String)this.server, (String)this.databaseName);
        }
        if (this.properties != null && this.properties.length() > 0) {
            logger.debug("appending additional properties [" + this.properties + "] to jdbc url [" + string + "]");
            if (!string.endsWith(";")) {
                string = string + ";";
            }
            string = string + this.properties;
        }
        string2 = new GenericQuery(string, this.userName, this.password);
        try {
            this.resultSets = string2.executeBatch(this.query, this.parameters);
        }
        catch (CTEDBException cTEDBException) {
            this.errorCode = cTEDBException.getErrorCode();
            this.errorMessage = cTEDBException.getMessage();
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to execute database query [" + this.query + "]", (Throwable)cTEDBException);
            activityContext.setFailureReason(cTEDBException.getMessage());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

