/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.CompletionStatus;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.EmbeddedWorkflow;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EvSecurity;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.MonitorWorkflowTask;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowEngine;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activity.XMLActivity;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.dom.InitializeExecution;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.OutputBuilder;
import commvault.msgs.CvEntities.WorkflowEntity;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.StartWorkflow;
import commvault.msgs.Workflow.WorkflowFlags;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class ExecuteWorkflow
implements XMLActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ExecuteWorkflow.class);
    private static final long SLEEP_TIME = 1000L;
    private String processInputs;
    private String outputs = null;
    private MonitorWorkflowTask.MonitorTask task;
    private WF_Process_t completedRow = null;
    private EmbeddedWorkflow process;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        try {
            AttemptStatus attemptStatus = this.execute2(activityContext);
            return attemptStatus;
        }
        finally {
            if (this.task != null) {
                MonitorWorkflowTask.getInstance().removeTask(this.task);
            }
            if (this.process != null && this.process.getStatus().isJobComplete()) {
                activityContext.getParent().removeChild((ProcessContext)this.process);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute2(ActivityContext activityContext) throws InterruptedException {
        EvalManager evalManager;
        Object object;
        WF_SuperProcess_t wF_SuperProcess_t = activityContext.getDataAccess().newSuperProcess();
        if (activityContext.getSubJobId() == null || activityContext.getSubJobId() == 0L) {
            if (!activityContext.getContext().isLoggedIn()) {
                logger.error(Long.valueOf(activityContext.getJobId()), "user is not logged in");
                activityContext.setFailureReason(new EvMessageContainer("user is not logged in"));
                return AttemptStatus.FAILED;
            }
            if (activityContext.isJobMode()) {
                long l;
                String string;
                int n;
                ResultSet resultSet;
                PreparedStatement preparedStatement;
                block57: {
                    String string2 = "Select WorkflowId, Name, flags From WF_Definition Where activityId = " + activityContext.getActivityId();
                    try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
                        preparedStatement = cTEDBReservation.createStatement(string2);
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            n = resultSet.getInt("WorkflowId");
                            string = resultSet.getString("Name");
                            int n2 = resultSet.getInt("flags");
                            break block57;
                        }
                        logger.error(Long.valueOf(activityContext.getJobId()), "could not find workflow definition for activity id [" + activityContext.getActivityId() + "]");
                        EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_LOAD_DEFINITION", (Object[])new Object[0]);
                        throw new EvFailureException(evMessageContainer);
                    }
                }
                try {
                    preparedStatement = activityContext.getContext().getMasterImpersonation();
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve master commcell capabilities for user [" + activityContext.getContext().getUserName() + "]");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                try {
                    if (!EvSecurity.canExecuteWorkflow((int)n, (int)activityContext.getCreatorId())) {
                        resultSet = EventMessage.getContainer((String)"GUIMSG_SECURITY_USER_CAPABILITY", (Object[])new Object[]{activityContext.getCreator(), Capability.EXECUTE_WORKFLOW.getDisplayName(), string});
                        String string3 = EventMessage.getInstance().formatMessage((EvMessageContainer)resultSet, 0);
                        logger.error(Long.valueOf(activityContext.getJobId()), string3);
                        activityContext.setFailureReason((EvMessageContainer)resultSet);
                        return AttemptStatus.FAILED;
                    }
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error retrieving workflow capabilities for user id [" + activityContext.getCreatorId() + "]", (Throwable)cTEDBException);
                    activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
                    return AttemptStatus.FAILED;
                }
                resultSet = new StartWorkflow();
                resultSet.setClient(WorkflowProperties.getInstance().getClient());
                resultSet.setOptions(this.processInputs);
                resultSet.getSubTask().setSubtaskId(activityContext.getSubTaskId());
                resultSet.getSubTask().setTaskId(activityContext.getTaskId());
                resultSet.getWorkflow().setWorkflowId(n);
                resultSet.getWorkflow().setWorkflowName(string);
                try {
                    l = WorkflowEngine.getInstance().submit((StartWorkflow)resultSet, preparedStatement.getUser(), null);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to start workflow [" + string + "]");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                logger.info(Long.valueOf(activityContext.getJobId()), "started job id [%s] for workflow [%s]", new Object[]{l, string});
                activityContext.setSubJobId(l);
                activityContext.save();
                return this.monitorJob(activityContext);
            }
            logger.debug(Long.valueOf(activityContext.getJobId()), "creating new [WF_SuperProcess] record for ProcessStepId [%s]", new Object[]{activityContext.getProcessStepId()});
            wF_SuperProcess_t = activityContext.getDataAccess().newSuperProcess();
            wF_SuperProcess_t.ProcessStepId.set(activityContext.getProcessStepId());
            wF_SuperProcess_t.State.set(Integer.valueOf(ExecutionState.STARTING.toInt()));
            wF_SuperProcess_t.Started.set(Integer.valueOf(DateUtilities.getNow()));
            wF_SuperProcess_t.jobId.set(Long.valueOf(activityContext.getJobId()));
            try {
                wF_SuperProcess_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to save new super process record for child workflow [" + activityContext.getUniqueName() + "]", (Throwable)cTEDBException);
                activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
                return AttemptStatus.FAILED;
            }
            object = activityContext.getDataAccess().getChildDataAccess(wF_SuperProcess_t.SuperProcessId.get().intValue());
            try {
                this.process = this.buildEmbeddedProcess(activityContext, wF_SuperProcess_t, (DataAccessLayer)object);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            wF_SuperProcess_t.DeploymentId.set(this.process.getDeploymentId());
            try {
                evalManager = new EvalManager((WorkflowContext)this.process);
                if (this.process.getOnStart() != null && this.process.getOnStart().getScript().length() > 0) {
                    logger.debug(Long.valueOf(activityContext.getJobId()), "processing onStart script for embedded workflow [" + this.process.getName() + "]");
                    evalManager.evaluate(this.process.getOnStart());
                }
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error executing onStart script for embedded workflow [" + this.process.getName() + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            logger.info(Long.valueOf(activityContext.getJobId()), "starting embedded workflow [%s] with inputs [%s]", new Object[]{this.process.getName(), this.process.getWorkflowExecution().getInputs()});
        } else {
            if (activityContext.isJobMode()) {
                return this.monitorJob(activityContext);
            }
            logger.debug(Long.valueOf(activityContext.getJobId()), "retrieving existing [WF_SuperProcess] record for id [%s]", new Object[]{activityContext.getSubJobId()});
            try {
                wF_SuperProcess_t = activityContext.getDataAccess().getSuperProcess(activityContext.getSubJobId().longValue());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to load existing embedded workflow process with id [" + activityContext.getSubJobId() + "]", (Throwable)cTEDBException);
                activityContext.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
                return AttemptStatus.FAILED;
            }
            if (wF_SuperProcess_t == null) {
                logger.info(Long.valueOf(activityContext.getJobId()), "determined that job [" + activityContext.getSubJobId() + "] was started in v10 since super process record for it is null");
            } else if (!wF_SuperProcess_t.ProcessStepId.get().equals(activityContext.getProcessStepId())) {
                logger.info(Long.valueOf(activityContext.getJobId()), "determined that job [" + activityContext.getSubJobId() + "] was started in v10 since process step id for super process record [" + wF_SuperProcess_t.ProcessStepId.get() + "] does not match that of local step id [" + activityContext.getProcessStepId() + "]");
            } else {
                logger.info(Long.valueOf(activityContext.getJobId()), "resume monitoring embedded job for super process id [" + wF_SuperProcess_t.SuperProcessId.get() + "]");
            }
            if (wF_SuperProcess_t == null || !wF_SuperProcess_t.ProcessStepId.get().equals(activityContext.getProcessStepId())) {
                return this.monitorJob(activityContext);
            }
            object = activityContext.getDataAccess().getChildDataAccess(wF_SuperProcess_t.SuperProcessId.get().intValue());
            try {
                this.process = this.buildEmbeddedProcess(activityContext, wF_SuperProcess_t, (DataAccessLayer)object);
            }
            catch (EvFailureException evFailureException) {
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            wF_SuperProcess_t.jobId.set(Long.valueOf(activityContext.getJobId()));
            wF_SuperProcess_t.DeploymentId.set(this.process.getDeploymentId());
        }
        activityContext.getParent().registerChild((ProcessContext)this.process);
        object = new EmbeddedManager((ProcessContext)this.process);
        ((EmbeddedManager)((Object)object)).worker();
        if (activityContext.getStatus() == ProcessStatus.RUNNING && object.getSize() == 0 || activityContext.getStatus() == ProcessStatus.FAILED) {
            if (activityContext.getStatus() != ProcessStatus.FAILED) {
                try {
                    evalManager = new EvalManager((WorkflowContext)this.process);
                    if (this.process.getOnComplete() != null && this.process.getOnComplete().getScript().length() > 0) {
                        logger.debug(Long.valueOf(activityContext.getJobId()), "processing onComplete script for embedded workflow [%s]", new Object[]{this.process.getName()});
                        evalManager.evaluate(this.process.getOnComplete());
                    }
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error executing onComplete script for embedded workflow [" + this.process.getName() + "]");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
            }
            this.process.complete();
            try {
                this.process.setOutputs(OutputBuilder.buildOutputs((ProcessContext)this.process, (boolean)true));
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to build outputs for embedded workflow [" + this.process.getName() + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            if (this.process.getOutputs() != null && this.process.getOutputs().length() > 0) {
                try {
                    evalManager = WorkflowElement.parse((String)this.process.getOutputs());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse outputs from embedded workflow [" + this.process.getName() + "]");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                if (evalManager != null && evalManager.getChildren().size() > 0) {
                    this.outputs = this.process.getOutputs();
                }
            }
            if (this.outputs == null) {
                try {
                    evalManager = WorkflowElement.parse((String)this.process.getWorkflowExecution().serialize());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse workflow execution document");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                String string = String.format("SELECT Outputs FROM WF_ProcessSteps WHERE Outputs IS NOT NULL AND ParentId = %s", activityContext.getProcessStepId());
                try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();){
                    ResultSet resultSet = cTEDBReservation.executeQuery(string);
                    while (resultSet.next()) {
                        evalManager.addContent(WorkflowElement.parse((String)resultSet.getString(1)));
                    }
                }
                this.outputs = "<outputs>" + evalManager.toString() + "</outputs>";
            }
        } else if (activityContext.getStatus() == ProcessStatus.SUSPEND_PENDING || activityContext.getStatus() == ProcessStatus.SUSPENDED) {
            activityContext.setStatus(ProcessStatus.SUSPENDED);
            activityContext.setCurrentPhase(-1);
        } else {
            logger.warn(Long.valueOf(activityContext.getJobId()), "embedded workflow [%s] is exiting with status [%s], step count [%s]", new Object[]{this.process.getName(), activityContext.getStatus().toString(), object.getSize()});
            activityContext.repeat(Integer.valueOf(0));
        }
        return AttemptStatus.SUCCESS;
    }

    public void setInputs(String string) {
        this.processInputs = string;
    }

    public String getOutputs() {
        return this.outputs;
    }

    public ActivitySchema getSchema(String string) {
        return null;
    }

    private EmbeddedWorkflow buildEmbeddedProcess(ActivityContext activityContext, WF_SuperProcess_t wF_SuperProcess_t, DataAccessLayer dataAccessLayer) throws EvFailureException {
        int n;
        String string;
        int n2;
        ResultSet resultSet;
        block21: {
            PreparedStatement preparedStatement;
            block20: {
                String string2 = "Select WorkflowId, Name, flags From WF_Definition Where activityId = " + activityContext.getActivityId();
                try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
                    preparedStatement = cTEDBReservation.createStatement(string2);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n2 = resultSet.getInt("WorkflowId");
                        string = resultSet.getString("Name");
                        n = resultSet.getInt("flags");
                        break block20;
                    }
                    logger.error(Long.valueOf(activityContext.getJobId()), "could not find workflow definition for activity id [" + activityContext.getActivityId() + "]");
                    EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_LOAD_DEFINITION", (Object[])new Object[0]);
                    throw new EvFailureException(evMessageContainer);
                }
            }
            preparedStatement = new WorkflowEntity();
            preparedStatement.setWorkflowName(string);
            preparedStatement.setWorkflowId(n2);
            if (wF_SuperProcess_t.DeploymentId.isNull() || wF_SuperProcess_t.DeploymentId.get() == 0) {
                try {
                    resultSet = CommServUtils.getWorkflowDeployment((WorkflowEntity)preparedStatement, (int)0);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve engine deployment record for embedded workflow [" + preparedStatement.getWorkflowName() + "]");
                    throw new EvFailureException(evFailureException.getMessageContainer());
                }
            }
            resultSet = new WF_Deployments_t();
            try {
                if (resultSet.fill("DeploymentId = " + wF_SuperProcess_t.DeploymentId.get())) break block21;
                try {
                    resultSet = CommServUtils.getWorkflowDeployment((WorkflowEntity)preparedStatement, (int)0);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve engine deployment record for embedded workflow [" + preparedStatement.getWorkflowName() + "]");
                    throw new EvFailureException(evFailureException.getMessageContainer());
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve engine deployment record for embedded workflow [" + preparedStatement.getWorkflowName() + "]");
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
        }
        try {
            SecurityContext securityContext = activityContext.getContext().getMasterImpersonation();
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve master commcell capabilities for user [" + activityContext.getContext().getUserName() + "]");
            throw evFailureException;
        }
        try {
            if (!EvSecurity.canExecuteWorkflow((int)n2, (int)activityContext.getCreatorId())) {
                EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"GUIMSG_SECURITY_USER_CAPABILITY", (Object[])new Object[]{activityContext.getCreator(), Capability.EXECUTE_WORKFLOW.getDisplayName(), string});
                String string3 = EventMessage.getInstance().formatMessage(evMessageContainer, 0);
                logger.error(Long.valueOf(activityContext.getJobId()), string3);
                throw new EvFailureException(evMessageContainer);
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error retrieving workflow capabilities for user id [" + activityContext.getContext().getUserId() + "]", (Throwable)cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if ((n & WorkflowFlags.DISABLED.getEnumValue()) == WorkflowFlags.DISABLED.getEnumValue()) {
            logger.error(Long.valueOf(activityContext.getJobId()), "cannot start workflow [" + string + "] because activity is disabled");
            EvMessageContainer evMessageContainer = new EvMessageContainer("workflow activity is disabled");
            evMessageContainer.setErrorCode(1301);
            throw new EvFailureException(evMessageContainer);
        }
        EmbeddedWorkflow embeddedWorkflow = new EmbeddedWorkflow(activityContext, (WF_Deployments_t)resultSet, wF_SuperProcess_t, dataAccessLayer, this.processInputs);
        embeddedWorkflow.initialize();
        if (embeddedWorkflow.getExecutionState() == ExecutionState.STARTING) {
            InitializeExecution.initialize((ProcessContext)embeddedWorkflow);
            embeddedWorkflow.save();
            activityContext.setSubJobId((long)embeddedWorkflow.getSuperProcessId().intValue());
            activityContext.save();
        }
        return embeddedWorkflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AttemptStatus monitorJob(final ActivityContext activityContext) throws InterruptedException {
        logger.info(Long.valueOf(activityContext.getJobId()), "monitoring status of workflow job [%s]", new Object[]{activityContext.getSubJobId()});
        activityContext.setFailureReason("waiting on job id [%s]", new Object[]{activityContext.getSubJobId()});
        activityContext.save();
        activityContext.getJobManager().updatePendingReason();
        this.task = new MonitorWorkflowTask.MonitorTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performTask(WF_Process_t wF_Process_t) {
                Object object = activityContext.getLock();
                synchronized (object) {
                    ExecuteWorkflow.this.completedRow = wF_Process_t;
                    activityContext.getLock().notifyAll();
                }
            }

            public long getJobId() {
                return activityContext.getSubJobId();
            }

            public WorkflowContext getContext() {
                return activityContext;
            }
        };
        MonitorWorkflowTask.getInstance().addTask(this.task);
        while (true) {
            Object object = activityContext.getLock();
            synchronized (object) {
                if (this.completedRow != null) {
                    WorkflowElement workflowElement;
                    ProcessStatus processStatus = ProcessStatus.fromInt((int)this.completedRow.Status.get());
                    if (!this.completedRow.outputs.isNull() && this.completedRow.outputs.get().length() > 0) {
                        try {
                            workflowElement = WorkflowElement.parse((String)this.completedRow.outputs.get());
                        }
                        catch (EvFailureException evFailureException) {
                            logger.error(Long.valueOf(activityContext.getJobId()), "failed to load outputs from job [" + this.completedRow.jobId.get() + "]");
                            activityContext.setFailureReason(evFailureException.getMessageContainer());
                            return AttemptStatus.FAILED;
                        }
                        if (workflowElement != null && workflowElement.getChildren().size() > 0) {
                            this.outputs = this.completedRow.outputs.get();
                        }
                    }
                    if (this.outputs == null) {
                        try {
                            workflowElement = WorkflowElement.parse((String)this.completedRow.Execution.get());
                        }
                        catch (EvFailureException evFailureException) {
                            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse workflow execution document");
                            activityContext.setFailureReason(evFailureException.getMessageContainer());
                            return AttemptStatus.FAILED;
                        }
                        String string = String.format("SELECT Outputs FROM WF_ProcessSteps WHERE Outputs IS NOT NULL AND jobId = %s AND ParentId IS NULL", activityContext.getSubJobId());
                        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();){
                            ResultSet resultSet = cTEDBReservation.executeQuery(string);
                            while (resultSet.next()) {
                                WorkflowElement workflowElement2 = WorkflowElement.parse((String)resultSet.getString(1));
                                workflowElement.removeChildren(workflowElement2.getName());
                                workflowElement.addContent(workflowElement2);
                            }
                        }
                        this.outputs = "<outputs>" + workflowElement.toString() + "</outputs>";
                    }
                    if (processStatus.getCompletionStatus() != CompletionStatus.COMPLETED && processStatus.getCompletionStatus() != CompletionStatus.COMPLETED_PARTIAL) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "workflow job [" + this.completedRow.jobId.get() + "] failed with status [" + processStatus.toString() + "]");
                        activityContext.getParent().removeFailures(activityContext.getFailures());
                        activityContext.getFailures().clear();
                        activityContext.setFailureReason(new EvMessageContainer("workflow job [%s] failed", new Object[]{this.completedRow.jobId.get()}));
                        return AttemptStatus.FAILED;
                    }
                    logger.info(Long.valueOf(activityContext.getJobId()), "workflow job [%s] has completed", new Object[]{this.completedRow.jobId.get()});
                    return AttemptStatus.SUCCESS;
                }
                if (activityContext.getStatus() != ProcessStatus.RUNNING) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity [%s] since it has a status of [%s]", new Object[]{activityContext.getFriendlyName(), activityContext.getStatus()});
                    activityContext.repeat(Integer.valueOf(0));
                    return AttemptStatus.SUCCESS;
                }
                if (!activityContext.isRunning()) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity [%s] since the workflow is shutting down", new Object[]{activityContext.getFriendlyName()});
                    activityContext.repeat(Integer.valueOf(0));
                    return AttemptStatus.SUCCESS;
                }
                activityContext.getLock().wait(1000L);
            }
        }
    }

    private class EmbeddedManager
    extends ProcessManager {
        public EmbeddedManager(ProcessContext processContext) {
            super(processContext);
        }

        protected void worker() {
            super.worker();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() {
            Object object = this.workflow.getLock();
            synchronized (object) {
                if (this.workflow.getJobManager() != null) {
                    this.workflow.getJobManager().save();
                }
                this.workflow.save();
            }
        }
    }
}

