/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activities.CommandActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.EncryptedString;

public class ExecuteCommand
extends CommandActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ExecuteCommand.class);
    @Input(documentation="the remote host to execute the command on")
    public ClientEntity client;
    @Input(documentation="the host username to execute the command as", required=true)
    public String impersonateUserName;
    @Input(documentation="the credentials to execute the command as", required=true)
    public EncryptedString impersonateUserPassword;
    @Input(documentation="the path to the executable", required=true)
    public String startUpPath;
    @Input(documentation="the command to be executed", required=true)
    public String command;
    @Input(documentation="arguments to pass into command")
    public String arguments;
    @Input(documentation="tells the activity to wait for process to complete and retrieve the output from the command", defaultValue="true")
    public Boolean waitForProcessCompletion;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.command == null || this.command.length() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "no command was passed into activity to execute");
            return AttemptStatus.SUCCESS;
        }
        String string = this.client != null && this.client.getClientName().length() > 0 ? this.client.getClientName() : WorkflowProperties.getInstance().getClient().getClientName();
        if (this.waitForProcessCompletion == null) {
            this.waitForProcessCompletion = true;
        }
        try {
            return this.executeCommand(activityContext, string, this.impersonateUserName, this.impersonateUserPassword, this.startUpPath, this.command, "", null, this.arguments, this.waitForProcessCompletion);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
    }
}

