/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessInputs;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.WorkflowCompletionStatus;

public class EndActivity
implements Activity,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EndActivity.class);
    @Input
    public WorkflowCompletionStatus completionStatus;
    @Input
    public String failureMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (activityContext.getPostOperations() != null && activityContext.getPostOperations().getOutputs().length() > 0) {
            WorkflowElement workflowElement;
            logger.debug(Long.valueOf(activityContext.getJobId()), "processing post operations");
            try {
                workflowElement = WorkflowElement.parse((String)activityContext.getPostOperations().getOutputs());
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error parsing post operation outputs");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            try {
                WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
                workflowEvaluator.processElement(workflowElement);
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error processing expressions in post operation outputs [" + activityContext.getPostOperations().getOutputs() + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            logger.info(Long.valueOf(activityContext.getJobId()), "updating process outputs with xml [%s]", new Object[]{String.valueOf(workflowElement)});
            activityContext.getWorkflowExecution().mergeOutputs(workflowElement);
        }
        return AttemptStatus.SUCCESS;
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new DetermineInputs(), new ProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new ProcessCompletionHandler()};
    }

    public class ProcessCompletionHandler
    implements ProcessHandler {
        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            if (EndActivity.this.completionStatus == WorkflowCompletionStatus.FAILED) {
                logger.info(Long.valueOf(activityContext.getJobId()), "marking workflow [%s] failed", new Object[]{activityContext.getWorkflowName()});
                EvMessageContainer evMessageContainer = EndActivity.this.failureMessage == null || EndActivity.this.failureMessage.length() == 0 ? EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_BY_ACTIVITY", (Object[])new Object[]{activityContext.getDisplayName()}) : new EvMessageContainer(EndActivity.this.failureMessage);
                activityContext.getParent().setFailureReason(evMessageContainer);
                activityContext.getParent().setStatus(ProcessStatus.FAILED);
            } else if (EndActivity.this.completionStatus == WorkflowCompletionStatus.COMPLETED_WITH_ERRORS) {
                logger.info(Long.valueOf(activityContext.getJobId()), "marking workflow [%s] with completed with errors", new Object[]{activityContext.getWorkflowName()});
                if (EndActivity.this.failureMessage != null && EndActivity.this.failureMessage.length() > 0) {
                    activityContext.setFailureReason(new EvMessageContainer(EndActivity.this.failureMessage));
                }
                activityContext.setCompletedWithErrors(true);
            }
        }
    }
}

