/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.TagsAndProperties;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.util.ArrayList;
import java.util.List;
import workflow.types.NameValue;
import workflow.types.SimpleType;
import workflow.types.WebMethod;
import workflow.types.WebRequest;
import workflow.types.XML;

public class ViewCustomProperties
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ViewCustomProperties.class);
    @Input(documentation="The GUID of the file or folder", required=true)
    public String fileOrFolderGUID;
    @Input(documentation="Property Filter", defaultValue="")
    public String filter;
    @Input(documentation="The share ID")
    public String shareId;
    @Input(documentation="IsPublicShare", defaultValue="false")
    public Boolean isPublicShare;
    @Output(documentation="Custom Properties as Name values")
    public List<NameValue> CustomProperties;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        String string = null;
        string = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive/file/" + this.fileOrFolderGUID + "/properties" : (this.isPublicShare != false ? "/SearchSvc/CVWebService.svc/drive/publicshare/" + this.shareId + "/file/" + this.fileOrFolderGUID + "/properties" : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId + "/file/" + this.fileOrFolderGUID + "/properties");
        if (!this.filter.equals("")) {
            string = string + "?propertyFilter=" + this.filter;
        }
        String string2 = "QSDKONLY " + activityContext.getContext().getToken();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        if (!this.isPublicShare.booleanValue()) {
            arrayList.add(new NameValue("Authtoken", string2));
        }
        arrayList.add(new NameValue("Accept", "application/xml"));
        webRequest.setUrl(string);
        webRequest.setHeaders(arrayList);
        webRequest.setMethod(WebMethod.GET);
        logger.debug("sending request to server");
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                logger.error("Server return with message : " + this.output.toString());
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                return AttemptStatus.FAILED;
            }
            String string3 = this.output.toString();
            String string4 = ".//customProps/nameValues";
            try {
                List list = (List)XMLQuery.query((String)string3, (String)string4, (SimpleType)SimpleType.XML, (boolean)true);
                this.CustomProperties = new ArrayList<NameValue>();
                for (int i = 0; i < list.size(); ++i) {
                    this.CustomProperties.add(new NameValue(((XML)list.get(i)).getAttributeValue("name"), ((XML)list.get(i)).getAttributeValue("value")));
                }
            }
            catch (EvFailureException evFailureException) {
                logger.error("Could not retrieve errorCode from XML");
            }
        }
        return attemptStatus;
    }
}

