/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.Share;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.util.ArrayList;
import workflow.types.NameValue;
import workflow.types.SimpleType;
import workflow.types.WebMethod;
import workflow.types.WebRequest;

public class DeleteShare
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DeleteShare.class);
    @Input(documentation="The share ID", required=true)
    public String shareId;
    @Output(documentation="Error Code")
    public String errorCode;
    @Output(documentation="Error Message")
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        String string = "/SearchSvc/CVWebService.svc/ShareFolder/" + this.shareId;
        String string2 = "QSDKONLY " + activityContext.getContext().getToken();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        arrayList.add(new NameValue("Authtoken", string2));
        arrayList.add(new NameValue("Accept", "application/xml"));
        webRequest.setUrl(string);
        webRequest.setHeaders(arrayList);
        webRequest.setMethod(WebMethod.DELETE);
        logger.debug("sending request to server");
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                logger.error("Server return with message : " + this.output.toString());
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                this.errorCode = "1";
                this.errorMessage = "Operation Failed";
                return AttemptStatus.FAILED;
            }
            String string3 = this.output.toString();
            String string4 = ".//@errorCode";
            String string5 = ".//@errorMessage";
            try {
                this.errorCode = (String)XMLQuery.query((String)string3, (String)string4, (SimpleType)SimpleType.String, (boolean)false);
                this.errorMessage = (String)XMLQuery.query((String)string3, (String)string5, (SimpleType)SimpleType.String, (boolean)false);
            }
            catch (EvFailureException evFailureException) {
                logger.error("Could not retrieve errorCode or String from XML");
            }
        }
        return attemptStatus;
    }
}

