/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.FileOperations;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import workflow.types.NameValue;
import workflow.types.OutputFormat;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;

public class SearchFolderContents
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SearchFolderContents.class);
    @Input(documentation="The path of the folder", required=true)
    public String folderPathOrGUID;
    @Input(documentation="The number of results to be listed in a page", defaultValue="50")
    public String limit;
    @Input(documentation="The number from which the results will be displayed", defaultValue="0")
    public String offset;
    @Input(documentation="Add this filter to display the search or browse results", defaultValue="")
    public String FilterXML;
    @Input(documentation="The share ID")
    public String shareId;
    @Input(documentation="The Output Format", defaultValue="xml")
    public OutputFormat acceptHeader;
    @Output(documentation="Output contents")
    public String responseMsg;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        try {
            this.folderPathOrGUID = URLEncoder.encode(this.folderPathOrGUID, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("URL Encoding failed with exception: " + unsupportedEncodingException.toString());
        }
        String string = null;
        string = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive" : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId;
        string = this.folderPathOrGUID.matches("[0-9a-fA-F]{8}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{12}") ? string.concat("/folder/" + this.folderPathOrGUID + "/action/search") : string.concat("/action/search?path=" + this.folderPathOrGUID);
        String string2 = "QSDKONLY " + activityContext.getContext().getToken();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        arrayList.add(new NameValue("Authtoken", string2));
        arrayList.add(new NameValue("Accept", "application/" + this.acceptHeader));
        arrayList.add(new NameValue("limit", this.limit));
        arrayList.add(new NameValue("offset", this.offset));
        webRequest.setUrl(string);
        webRequest.setHeaders(arrayList);
        webRequest.setMethod(WebMethod.POST);
        webRequest.setPostType(WebPostType.Raw);
        webRequest.setPostContent((Object)this.FilterXML);
        logger.debug("sending request to server with XML content: " + this.FilterXML);
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                logger.error("Server return with message : " + this.output.toString());
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                this.responseMsg = this.output.toString();
                return AttemptStatus.FAILED;
            }
            this.responseMsg = this.output.toString();
        }
        return AttemptStatus.SUCCESS;
    }
}

