/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.FileIO;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activities.EdgeDrive.FileIO.InitiateChunkUpload;
import commvault.cte.workflow.activities.EdgeDrive.FileIO.UploadFileChunk;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import workflow.types.Binary;
import workflow.types.NameValue;
import workflow.types.OutputFormat;
import workflow.types.SimpleType;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;

public class UploadFile
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UploadFile.class);
    @Input(documentation="The file to be uploaded", required=true)
    public File file;
    @Input(documentation="The path to the destination folder where the file will be uploaded", required=true)
    public String parentFolderPath;
    @Input(documentation="The share ID")
    public String shareId;
    @Input(documentation="Optional New FileName to Upload")
    public String fileName;
    @Output(documentation="File GUID")
    public String GUID;
    @Output(documentation="errorcode")
    public String errorCode;
    @Output(documentation="chunkOffset")
    public String chunkOffset;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object;
        Object object2;
        WebRequest webRequest = new WebRequest();
        if (!this.file.exists()) return AttemptStatus.FAILED;
        if (!this.file.isFile()) return AttemptStatus.FAILED;
        String string = "QSDKONLY " + activityContext.getContext().getToken();
        if (this.fileName.isEmpty()) {
            this.fileName = this.file.getName();
        }
        String string2 = Long.toString(this.file.lastModified() / 1000L, 10);
        String string3 = Long.toString(this.file.length(), 10);
        String string4 = "";
        double d = 1048576.0;
        long l = this.file.length();
        double d2 = (double)l / d;
        string4 = d2 > 4.0 ? "chunkedFile" : "fullFile";
        if (string4.equals("chunkedFile")) {
            InitiateChunkUpload initiateChunkUpload = new InitiateChunkUpload(this.fileName, string3, string2, this.parentFolderPath, this.file, this.shareId);
            AttemptStatus attemptStatus = initiateChunkUpload.execute(activityContext);
            if (attemptStatus == AttemptStatus.FAILED) {
                logger.error("Could not create the edge drive session");
                this.errorCode = "1";
                this.GUID = "0";
                this.chunkOffset = "0";
                return attemptStatus;
            }
            int n = WorkflowRegistry.getInstance().getEdgeDriveFileChunkSize();
            int n2 = n * 1024;
            byte[] byArray = new byte[n2];
            int n3 = Integer.parseInt(string3) / n2;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));){
                int n4 = 0;
                int n5 = 1;
                long l2 = 0L;
                UploadFileChunk uploadFileChunk = new UploadFileChunk(initiateChunkUpload.requestId, this.shareId);
                Binary binary = new Binary();
                while ((n4 = bufferedInputStream.read(byArray)) > 0) {
                    if (n4 != n2 || (l2 += (long)n4) == l) {
                        binary.setBytes(byArray);
                        uploadFileChunk.setFile(binary);
                        uploadFileChunk.setEOF(true);
                        uploadFileChunk.setOutputFormat(OutputFormat.xml);
                        attemptStatus = uploadFileChunk.execute(activityContext);
                        if (attemptStatus == AttemptStatus.FAILED) {
                            logger.error("Could not upload the last file chunk");
                            AttemptStatus attemptStatus2 = attemptStatus;
                            return attemptStatus2;
                        }
                    } else {
                        binary.setBytes(byArray);
                        uploadFileChunk.setFile(binary);
                        uploadFileChunk.setEOF(false);
                        uploadFileChunk.setOutputFormat(OutputFormat.xml);
                        attemptStatus = uploadFileChunk.execute(activityContext);
                        if (attemptStatus == AttemptStatus.FAILED) {
                            logger.error("Could not upload a file chunk");
                            AttemptStatus attemptStatus3 = attemptStatus;
                            return attemptStatus3;
                        }
                    }
                    if (n5 == n3) {
                        byArray = new byte[Integer.parseInt(string3) % n2];
                    }
                    ++n5;
                }
                bufferedInputStream.close();
                if (attemptStatus == AttemptStatus.SUCCESS) {
                    logger.info("File Chunk Upload was successful");
                }
                this.errorCode = uploadFileChunk.errorCode;
                this.GUID = uploadFileChunk.GUID;
                this.chunkOffset = uploadFileChunk.chunkOffset;
                AttemptStatus attemptStatus4 = attemptStatus;
                return attemptStatus4;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return AttemptStatus.FAILED;
            }
            catch (IOException iOException) {
                return AttemptStatus.FAILED;
            }
        }
        String string5 = null;
        string5 = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive/file/action/upload?uploadType=" + string4 + "&forceRestart=true" : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId + "/file/action/upload?uploadType=" + string4 + "&forceRestart=true";
        String string6 = null;
        String string7 = null;
        try {
            string6 = Base64.getEncoder().encodeToString(this.fileName.getBytes("utf-8"));
            string7 = Base64.getEncoder().encodeToString(this.parentFolderPath.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Base64 encryption failed");
            activityContext.setFailureReason(unsupportedEncodingException.getMessage());
            return AttemptStatus.FAILED;
        }
        Binary binary = new Binary();
        try {
            object2 = new BufferedInputStream(new FileInputStream(this.file));
            object = new byte[(int)this.file.length()];
            ((FilterInputStream)object2).read((byte[])object);
            binary.setBytes(object);
            ((BufferedInputStream)object2).close();
        }
        catch (Exception exception) {
            return AttemptStatus.FAILED;
        }
        object2 = new ArrayList();
        object2.add(new NameValue("FileName", string6));
        object2.add(new NameValue("ParentFolderPath", string7));
        object2.add(new NameValue("FileSize", string3));
        object2.add(new NameValue("FileModifiedtime", string2));
        object2.add(new NameValue("Accept", "application/xml"));
        object2.add(new NameValue("Authtoken", string));
        webRequest.setUrl(string5);
        webRequest.setHeaders((List)object2);
        webRequest.setMethod(WebMethod.POST);
        webRequest.setPostType(WebPostType.Raw);
        webRequest.setPostContent((Object)binary);
        webRequest.setPostContentType(null);
        logger.debug("sending request to server");
        object = super.executeRequest(webRequest, activityContext);
        if (object != AttemptStatus.SUCCESS) return AttemptStatus.SUCCESS;
        if (this.statusCode != 200) {
            logger.error("Server return with message : " + this.output.toString());
            activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
            this.GUID = "0";
            this.chunkOffset = "0";
            this.errorCode = "1";
            return AttemptStatus.FAILED;
        }
        String string8 = this.output.toString();
        String string9 = ".//@fileGUID";
        String string10 = ".//@errorCode";
        String string11 = ".//@chunkOffset";
        try {
            this.GUID = (String)XMLQuery.query((String)string8, (String)string9, (SimpleType)SimpleType.String, (boolean)false);
            this.errorCode = (String)XMLQuery.query((String)string8, (String)string10, (SimpleType)SimpleType.String, (boolean)false);
            this.chunkOffset = (String)XMLQuery.query((String)string8, (String)string11, (SimpleType)SimpleType.String, (boolean)false);
            return AttemptStatus.SUCCESS;
        }
        catch (EvFailureException evFailureException) {
            logger.error("Could not retrieve errorCode from XML");
        }
        return AttemptStatus.SUCCESS;
    }
}

