/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.FileIO;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import workflow.types.NameValue;
import workflow.types.WebMethod;
import workflow.types.WebRequest;

public class PreviewFile
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(PreviewFile.class);
    @Input(documentation="The path or GUID of the file", required=true)
    public String filePathOrGUID;
    @Input(documentation="The format of the response", required=true)
    public String AcceptFormat;
    @Input(documentation="The share ID")
    public String shareId;
    @Input(documentation="IsPublicShare", defaultValue="false")
    public Boolean isPublicShare;
    @Output(documentation="File Object")
    public File PreviewFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object;
        WebRequest webRequest = new WebRequest();
        String string = null;
        string = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive" : (this.isPublicShare != false ? "/SearchSvc/CVWebService.svc/drive/publicshare/" + this.shareId : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId);
        String string2 = "";
        if (this.filePathOrGUID.matches("[0-9a-fA-F]{8}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{4}[0-9a-fA-F]{12}")) {
            string = string.concat("/file/" + this.filePathOrGUID + "/action/preview");
            string2 = this.filePathOrGUID;
        } else {
            object = new File(this.filePathOrGUID);
            string2 = ((File)object).getName();
            try {
                this.filePathOrGUID = URLEncoder.encode(this.filePathOrGUID, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error("URL Encoding failed with exception: " + unsupportedEncodingException.toString());
            }
            string = string.concat("/action/preview?path=" + this.filePathOrGUID);
        }
        object = "QSDKONLY " + activityContext.getContext().getToken();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        if (!this.isPublicShare.booleanValue()) {
            arrayList.add(new NameValue("Authtoken", (String)object));
        }
        arrayList.add(new NameValue("Accept", this.AcceptFormat));
        webRequest.setUrl(string);
        webRequest.setHeaders(arrayList);
        webRequest.setMethod(WebMethod.GET);
        logger.debug("sending request to server");
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                try {
                    logger.error("Server return with message : " + WorkflowUtils.readStream((InputStream)this.inputStream));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                return AttemptStatus.FAILED;
            }
            File file = new File(WorkflowProperties.getInstance().getJobResultsDir(), UUID.randomUUID().toString());
            file.mkdirs();
            this.PreviewFile = new File(file, string2);
            try {
                int n;
                FileOutputStream fileOutputStream = new FileOutputStream(this.PreviewFile);
                byte[] byArray = new byte[this.inputStream.available()];
                while ((n = this.inputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    EntityUtils.consume((HttpEntity)this.responseEntity);
                    if (this.response != null) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "commenting response.close");
                        this.response.close();
                    }
                }
                catch (IOException iOException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to close http response object", (Throwable)iOException);
                }
            }
        }
        return attemptStatus;
    }
}

