/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive.FileIO;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.EdgeDrive.AbstractHttpClientActivity;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import workflow.types.NameValue;
import workflow.types.SimpleType;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;

public class InitiateChunkUpload
extends AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InitiateChunkUpload.class);
    @Input(documentation="Name of the file to be uploaded", required=true)
    public String fileName;
    @Input(documentation="Size of the file to be uploaded", required=true)
    public String fileSize;
    @Input(documentation="The last modified time of the file to be uploaded", required=true)
    public String fileModifiedTime;
    @Input(documentation="The path to the destination folder where the file will be uploaded", required=true)
    public String parentFolderPath;
    @Input(documentation="Specifies whether the end of file has reached with the current file chunk", defaultValue="0")
    public String fileEOF;
    @Input(documentation="The file chunk to be uploaded")
    public File file;
    @Input(documentation="The share ID")
    public String shareId;
    @Output(documentation="Output XML")
    public String outputXml;
    @Output(documentation="Request ID")
    public String requestId;
    @Output(documentation="Number of uploaded bytes")
    public String chunkOffset;

    public InitiateChunkUpload(String string, String string2, String string3, String string4, File file, String string5) {
        this.fileName = string;
        this.fileSize = string2;
        this.fileModifiedTime = string3;
        this.parentFolderPath = string4;
        this.file = file;
        this.shareId = string5;
    }

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        WebRequest webRequest = new WebRequest();
        String string = null;
        string = this.shareId.isEmpty() ? "/SearchSvc/CVWebService.svc/drive/file/action/upload?uploadType=chunkedFile&forceRestart=true" : "/SearchSvc/CVWebService.svc/drive/share/" + this.shareId + "/file/action/upload?uploadType=chunkedFile&forceRestart=true";
        String string2 = "QSDKONLY " + activityContext.getContext().getToken();
        String string3 = null;
        String string4 = null;
        try {
            string3 = Base64.getEncoder().encodeToString(this.fileName.getBytes("utf-8"));
            string4 = Base64.getEncoder().encodeToString(this.parentFolderPath.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Base64 encryption failed");
            activityContext.setFailureReason(unsupportedEncodingException.getMessage());
            return AttemptStatus.FAILED;
        }
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>();
        arrayList.add(new NameValue("FileName", string3));
        arrayList.add(new NameValue("ParentFolderPath", string4));
        arrayList.add(new NameValue("FileSize", this.fileSize));
        arrayList.add(new NameValue("FileModifiedtime", this.fileModifiedTime));
        arrayList.add(new NameValue("Accept", "application/xml"));
        arrayList.add(new NameValue("Authtoken", string2));
        webRequest.setUrl(string);
        webRequest.setHeaders(arrayList);
        webRequest.setMethod(WebMethod.POST);
        webRequest.setPostType(WebPostType.Raw);
        logger.debug("sending request to server");
        AttemptStatus attemptStatus = super.executeRequest(webRequest, activityContext);
        if (attemptStatus == AttemptStatus.SUCCESS) {
            if (this.statusCode != 200) {
                logger.error("Server return with message : " + this.output.toString());
                activityContext.setFailureReason("Server returned an unexpected message. Please check logs for more info about the failure.");
                this.outputXml = this.output.toString();
                this.chunkOffset = "0";
                this.requestId = "0";
                return AttemptStatus.FAILED;
            }
            this.outputXml = this.output.toString();
            String string5 = ".//@requestId";
            String string6 = ".//@chunkOffset";
            try {
                this.chunkOffset = (String)XMLQuery.query((String)this.outputXml, (String)string6, (SimpleType)SimpleType.String, (boolean)false);
                this.requestId = (String)XMLQuery.query((String)this.outputXml, (String)string5, (SimpleType)SimpleType.String, (boolean)false);
            }
            catch (EvFailureException evFailureException) {
                logger.error("Could not retrieve GUID from XML");
            }
        }
        return AttemptStatus.SUCCESS;
    }
}

