/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.EdgeDrive;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activities.EdgeDrive.HttpDeleteWithBody;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.qnet.sys.CVPassword;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import workflow.types.Binary;
import workflow.types.NameValue;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;
import workflow.types.data.DataRow;
import workflow.types.data.MetaData;

public abstract class AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(AbstractHttpClientActivity.class);
    protected InputStream inputStream;
    protected HttpEntity responseEntity;
    protected CloseableHttpResponse response;
    @Output
    protected String output;
    @Output
    protected int statusCode;
    @Output
    protected DataRow headers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus executeRequest(WebRequest webRequest, ActivityContext activityContext) {
        Object object;
        Object object2;
        BasicCredentialsProvider basicCredentialsProvider2;
        NameValue nameValue3;
        NameValue nameValue22;
        Object object3;
        WorkflowProperties.WebServiceParameters webServiceParameters;
        if (webRequest == null) {
            webRequest = new WebRequest();
        }
        if (webRequest.getUrl() == null || webRequest.getUrl().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no url provided");
            activityContext.setFailureReason("missing url");
            return AttemptStatus.FAILED;
        }
        if (webRequest.getUrl().startsWith("/")) {
            webServiceParameters = WorkflowProperties.getInstance().getEdgeDriveWebService();
            object3 = "";
            if (webServiceParameters != null) {
                object3 = webServiceParameters.getWebUrl();
            } else {
                webServiceParameters = WorkflowProperties.getInstance().getDefaultWebService();
            }
            if (webServiceParameters != null) {
                object3 = webServiceParameters.getWebUrl();
            } else {
                logger.warn("no default web server found on CommCell to prepend to url [" + webRequest.getUrl() + "]");
            }
            if (!webRequest.getUrl().toLowerCase().contains("CVWebService.svc".toLowerCase())) {
                object3 = ((String)object3).endsWith("/") ? object3 + webServiceParameters.getBasePath() : object3 + "/" + webServiceParameters.getBasePath();
            }
            logger.debug("url starts with '/' prepending default web service url [" + object3 + "]");
            webRequest.setUrl((String)object3 + webRequest.getUrl());
        }
        if (webRequest.getMethod() == null) {
            logger.info(Long.valueOf(activityContext.getJobId()), "web method not provided into activity, defaulting to Get");
            webRequest.setMethod(WebMethod.GET);
        }
        try {
            webServiceParameters = new URIBuilder(webRequest.getUrl());
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build the uri from url [" + webRequest.getUrl() + "]", (Throwable)uRISyntaxException);
            activityContext.setFailureReason(uRISyntaxException.getMessage());
            return AttemptStatus.FAILED;
        }
        if (webRequest.getParameters() != null && webRequest.getParameters().size() > 0) {
            for (NameValue nameValue22 : webRequest.getParameters()) {
                webServiceParameters.addParameter(nameValue22.getName(), nameValue22.getValue());
            }
        }
        try {
            object3 = webServiceParameters.build();
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build the uri from url [" + webRequest.getUrl() + "], parameters [" + webRequest.getParameters() + "]");
            activityContext.setFailureReason(uRISyntaxException.getMessage());
            return AttemptStatus.FAILED;
        }
        logger.debug("HTTP Client URL: " + ((URI)object3).toASCIIString());
        nameValue22 = null;
        HttpDeleteWithBody httpDeleteWithBody = null;
        if (webRequest.getMethod() == WebMethod.GET) {
            nameValue22 = new HttpGet((URI)object3);
        } else {
            if (webRequest.getMethod() == WebMethod.POST) {
                nameValue22 = new HttpPost((URI)object3);
            } else if (webRequest.getMethod() == WebMethod.DELETE) {
                httpDeleteWithBody = new HttpDeleteWithBody((URI)object3);
            } else {
                nameValue22 = new HttpPut((URI)object3);
            }
            if (webRequest.getPostType() == null || webRequest.getPostType() == WebPostType.Form) {
                nameValue3 = new ArrayList();
                if (webRequest.getPostParameters() != null) {
                    for (BasicCredentialsProvider basicCredentialsProvider2 : webRequest.getPostParameters()) {
                        logger.debug(Long.valueOf(activityContext.getJobId()), "Form Parameter: Name [%s], Value [%s]", new Object[]{basicCredentialsProvider2.getName(), basicCredentialsProvider2.getValue()});
                        nameValue3.add(new BasicNameValuePair(basicCredentialsProvider2.getName(), basicCredentialsProvider2.getValue()));
                    }
                }
                try {
                    object2 = new UrlEncodedFormEntity((List)nameValue3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to build form from parameters " + nameValue3, (Throwable)unsupportedEncodingException);
                    activityContext.setFailureReason(unsupportedEncodingException.getMessage());
                    return AttemptStatus.FAILED;
                }
            } else {
                if (webRequest.getPostContent() == null) {
                    webRequest.setPostContent((Object)"");
                }
                nameValue3 = null;
                if (webRequest.getPostContentType() != null && webRequest.getPostContentType().length() > 0) {
                    nameValue3 = ContentType.parse((String)webRequest.getPostContentType());
                }
                if (nameValue3 != null) {
                    logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Content Type: [%s]", new Object[]{nameValue3.getMimeType()});
                    logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Charset: [%s]", new Object[]{nameValue3.getCharset()});
                }
                if (webRequest.getPostContent() instanceof File) {
                    object2 = new FileEntity((File)webRequest.getPostContent(), (ContentType)nameValue3);
                    logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP File: [%s]", new Object[]{((File)webRequest.getPostContent()).getAbsolutePath()});
                } else if (webRequest.getPostContent() instanceof Binary) {
                    object2 = new ByteArrayEntity(((Binary)webRequest.getPostContent()).getBytes(), (ContentType)nameValue3);
                } else {
                    object2 = new StringEntity(String.valueOf(webRequest.getPostContent()), (ContentType)nameValue3);
                    logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Content: [%s]", new Object[]{String.valueOf(webRequest.getPostContent())});
                }
                logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Content Length: [%s]", new Object[]{object2.getContentLength()});
            }
            if (webRequest.getMethod() == WebMethod.DELETE) {
                if (httpDeleteWithBody == null) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "HTTP delete body is null");
                }
                logger.error(Long.valueOf(activityContext.getJobId()), "inside Set Entity");
                httpDeleteWithBody.setEntity((HttpEntity)object2);
            } else {
                ((HttpEntityEnclosingRequest)nameValue22).setEntity((HttpEntity)object2);
            }
        }
        if (webRequest.getHeaders() != null && webRequest.getHeaders().size() > 0) {
            for (NameValue nameValue3 : webRequest.getHeaders()) {
                logger.debug("HEADER: name [%s] value [%s]", new Object[]{nameValue3.getName(), nameValue3.getValue()});
                if (webRequest.getMethod() == WebMethod.DELETE) {
                    httpDeleteWithBody.addHeader(nameValue3.getName(), nameValue3.getValue());
                    continue;
                }
                nameValue22.addHeader(nameValue3.getName(), nameValue3.getValue());
            }
        }
        logger.debug("creating client builder");
        object2 = HttpClients.custom();
        logger.debug("setting system properties");
        object2.useSystemProperties();
        if (activityContext.getJobSettings().isHttpUseProxy()) {
            logger.info(Long.valueOf(activityContext.getJobId()), "using http proxy [%s], port [%s] for url address [%s]", new Object[]{activityContext.getJobSettings().getHttpProxySite(), activityContext.getJobSettings().getHttpProxyPort(), webRequest.getUrl()});
            nameValue3 = new HttpHost(activityContext.getJobSettings().getHttpProxySite(), activityContext.getJobSettings().getHttpProxyPort());
            object2.setProxy((HttpHost)nameValue3);
            if (activityContext.getJobSettings().isHttpUseProxyAuthentication()) {
                logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Proxy Username: [%s]", new Object[]{activityContext.getJobSettings().getHttpProxyUser()});
                object = new CVPassword();
                basicCredentialsProvider2 = new BasicCredentialsProvider();
                basicCredentialsProvider2.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(activityContext.getJobSettings().getHttpProxyUser(), object.decrypt(activityContext.getJobSettings().getHttpProxyPassword())));
                object2.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider2);
            }
        }
        logger.debug("creating httpclient");
        nameValue3 = object2.build();
        this.response = null;
        logger.debug("creating hashmap");
        object = new LinkedHashMap();
        try {
            if (webRequest.getMethod() == WebMethod.DELETE) {
                if (httpDeleteWithBody == null) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "HTTP delete body is null while executin");
                }
                logger.error(Long.valueOf(activityContext.getJobId()), "Exactly before executing");
                this.response = nameValue3.execute((HttpUriRequest)httpDeleteWithBody);
                if (this.response == null) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "response is null");
                }
            } else {
                this.response = nameValue3.execute((HttpUriRequest)nameValue22);
            }
            this.responseEntity = this.response.getEntity();
            this.output = ((URI)object3).toASCIIString().contains("action/download") || ((URI)object3).toASCIIString().contains("action/preview") ? "" : WorkflowUtils.readStream((InputStream)this.responseEntity.getContent());
            this.inputStream = this.responseEntity.getContent();
            this.statusCode = this.response.getStatusLine().getStatusCode();
            for (BasicCredentialsProvider basicCredentialsProvider3 : this.response.getAllHeaders()) {
                object.put(basicCredentialsProvider3.getName(), basicCredentialsProvider3.getValue());
            }
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to read response from url [" + webRequest.getUrl() + "]", (Throwable)exception);
            activityContext.setFailureReason(exception.getMessage());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        finally {
            if (!((URI)object3).toASCIIString().contains("action/download") && !((URI)object3).toASCIIString().contains("action/preview")) {
                try {
                    EntityUtils.consume((HttpEntity)this.responseEntity);
                    if (this.response != null) {
                        this.response.close();
                    }
                }
                catch (IOException iOException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to close http response object", (Throwable)iOException);
                }
            }
        }
        basicCredentialsProvider2 = new MetaData(object.keySet().toArray(new String[0]));
        this.headers = new DataRow((MetaData)basicCredentialsProvider2, object.values().toArray());
        return AttemptStatus.SUCCESS;
    }
}

