/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.XMLActivity;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.CustomScriptDefinition;
import java.util.List;
import java.util.Map;

public class CustomScriptActivity
implements XMLActivity,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CustomScriptActivity.class);
    private String inputs;
    private WorkflowElement root = new WorkflowElement("outputs");
    private Map<String, Object> inputMap;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object;
        CustomScriptDefinition customScriptDefinition;
        if (activityContext.getDefinition() == null || activityContext.getDefinition().length() == 0) {
            String string = String.format("missing input definition", new Object[0]);
            logger.error(Long.valueOf(activityContext.getJobId()), string);
            activityContext.setFailureReason(new EvMessageContainer(string));
            return AttemptStatus.FAILED;
        }
        try {
            customScriptDefinition = (CustomScriptDefinition)XMLDecoder.decode((String)activityContext.getDefinition());
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode input definition", (Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        try {
            this.inputMap = workflowEvaluator.getObjectMap(this.inputs, activityContext.getSchema().getInputs());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build input map");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        logger.debug("Input Map: %s", new Object[]{this.inputMap});
        try {
            object = activityContext.getEvaluator().evaluate(customScriptDefinition.getScript());
            logger.debug("evaluation of custom script returned [%s]", new Object[]{String.valueOf(object)});
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to evaluate script");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        List list = null;
        if (customScriptDefinition.getOutputName().trim().length() > 0) {
            try {
                list = activityContext.getMarshaller().encode(customScriptDefinition.getOutputName(), object);
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to marshal script output [" + String.valueOf(object) + "], type [" + object.getClass() + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
        } else {
            logger.debug(Long.valueOf(activityContext.getJobId()), "no output name defined in script, skipping creation of outputs");
        }
        if (list != null && list.size() > 0) {
            if (customScriptDefinition.getOutputList()) {
                this.root.addContent(list);
            } else {
                this.root.addContent((WorkflowElement)list.get(0));
            }
        }
        return AttemptStatus.SUCCESS;
    }

    public Object getInput(String string) {
        return this.inputMap.get(string);
    }

    public void setInputs(String string) {
        this.inputs = string;
    }

    public String getOutputs() {
        return this.root.toString();
    }

    public ActivitySchema getSchema(String string) {
        return null;
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
    }
}

