/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activities.CommandActivity;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.XMLInput;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.CustomCommandDefinition;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.UUID;

public class CustomCommandActivity
extends CommandActivity
implements XMLInput,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CustomCommandActivity.class);
    private String inputs;
    private Map<String, Object> inputMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Process process;
        Object object;
        String string;
        CustomCommandDefinition customCommandDefinition;
        if (activityContext.getDefinition() == null || activityContext.getDefinition().length() == 0) {
            String string2 = String.format("missing input definition for custom activity", new Object[0]);
            logger.error(Long.valueOf(activityContext.getJobId()), string2);
            activityContext.setFailureReason(new EvMessageContainer(string2));
            return AttemptStatus.FAILED;
        }
        try {
            customCommandDefinition = (CustomCommandDefinition)XMLDecoder.decode((String)activityContext.getDefinition());
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode input definition for custom activity", (Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        try {
            this.inputMap = workflowEvaluator.getObjectMap(this.inputs, activityContext.getSchema().getInputs());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build input map for activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        logger.debug("Input Map: %s", new Object[]{this.inputMap});
        try {
            string = workflowEvaluator.parseString(customCommandDefinition.getCommand());
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse command for activity");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        File file = new File(WorkflowRegistry.getInstance().getGalaxyTempDir(), UUID.randomUUID().toString() + ".cmd");
        try {
            object = new FileWriter(file);
            ((Writer)object).write(string);
            ((OutputStreamWriter)object).close();
            logger.debug(Long.valueOf(activityContext.getJobId()), String.format("built command file [%s]:", file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to write command file [" + file.getAbsolutePath() + "]", (Throwable)iOException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"JM_WORKFLOW_FAILED_BUILD_SCRIPT", (Object[])new Object[0]);
            activityContext.setFailureReason(evMessageContainer);
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        finally {
            file.delete();
        }
        object = Runtime.getRuntime();
        try {
            process = ((Runtime)object).exec(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to execute batch command [" + file.getAbsolutePath() + "]", (Throwable)iOException);
            activityContext.setFailureReason(new EvMessageContainer(iOException.getMessage()));
            return AttemptStatus.FAILED;
        }
        this.exitCode = process.waitFor();
        if (this.exitCode == 0) {
            try {
                if (process.getInputStream().available() > 0) {
                    this.commandOutput = WorkflowUtils.readStream((InputStream)process.getInputStream());
                }
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve output from command", (Throwable)exception);
            }
            logger.info(Long.valueOf(activityContext.getJobId()), "command result [%s]", new Object[]{this.commandOutput});
            return AttemptStatus.SUCCESS;
        }
        try {
            if (process.getErrorStream().available() > 0) {
                this.commandOutput = WorkflowUtils.readStream((InputStream)process.getErrorStream());
            }
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve error from command", (Throwable)exception);
        }
        logger.error(Long.valueOf(activityContext.getJobId()), "command exited with value [" + this.exitCode + "], error [" + this.commandOutput + "]");
        activityContext.setFailureReason(new EvMessageContainer(this.commandOutput));
        return AttemptStatus.FAILED;
    }

    public String getInput(String string) {
        Object object = this.inputMap.get(string);
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public void setInputs(String string) {
        this.inputs = string;
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) throws Exception {
    }
}

