/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.PasswordEncryptType;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.CommCellToken;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EvSecurity;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecuteException;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.SessionUtil;
import commvault.cte.workflow.ThreadManager;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.ExecuteCommandReq;
import commvault.msgs.App.ExecuteToolResp;
import commvault.msgs.App.GenericResp;
import commvault.msgs.App.ScriptType;
import commvault.msgs.CvEntities.ClientEntity;
import commvault.msgs.Workflow.RemoteCommandArguments;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import workflow.types.EncryptedString;

public abstract class CommandActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CommandActivity.class);
    private static final String STRING_FF;
    private static Boolean STRIP_XML_CHARS;
    @Output(documentation="the exitCode recieved from executing the command")
    public int exitCode;
    @Output(documentation="the return code recieved from completion of the command")
    public int errorCode;
    @Output(documentation="the output from the command or error message if it failed")
    public String commandOutput;
    private Map<Integer, String> exitCodeMessages = null;
    private String maskedString;

    private static boolean isStripXMLChars() {
        if (STRIP_XML_CHARS == null) {
            STRIP_XML_CHARS = WorkflowRegistry.getInstance().isStipXmlChars();
        }
        return STRIP_XML_CHARS;
    }

    public AttemptStatus executeCommand(ActivityContext activityContext, String string, String string2, EncryptedString encryptedString, String string3, String string4, String string5, ScriptType scriptType, String string6, boolean bl) throws EvFailureException, InterruptedException {
        return this.executeCommand(activityContext, string, string2, encryptedString, string3, string4, string5, scriptType, string6, bl, null, null, null);
    }

    public AttemptStatus executeCommand(ActivityContext activityContext, String string, String string2, EncryptedString encryptedString, String string3, String string4, String string5, ScriptType scriptType, String string6, boolean bl, String string7, String string8, Map<Integer, String> map) throws EvFailureException, InterruptedException {
        if (!activityContext.getContext().isLoggedIn()) {
            this.errorCode = 1;
            this.commandOutput = "user is not logged in";
            logger.error(Long.valueOf(activityContext.getJobId()), "user is not logged in");
            throw new EvFailureException(new EvMessageContainer("user is not logged in"));
        }
        this.exitCodeMessages = map;
        this.maskedString = string8;
        if (string7 == null) {
            String string9 = string5 != null && string5.length() > 0 ? "executing script type [" + scriptType + "] with arguments [" + string6 + "] on host [" + string + "]" : "executing command [" + string4 + "] with arguments [" + string6 + "] on host [" + string + "]";
            if (string2 != null && string2.length() > 0) {
                string9 = string9 + " as user [" + string2 + "]";
            }
            logger.info(Long.valueOf(activityContext.getJobId()), string9);
        } else {
            logger.info(Long.valueOf(activityContext.getJobId()), string7);
        }
        if (WorkflowRegistry.getInstance().isDirectCVDConnection()) {
            return this.executeCommandLocal(activityContext, string, string2, encryptedString, string3, string4, string5, scriptType, string6, bl, (SecurityContext)activityContext.getContext());
        }
        return this.executeCommandRemote(activityContext, string, string2, encryptedString, string3, string4, string5, scriptType, string6, bl, (SecurityContext)activityContext.getContext());
    }

    private AttemptStatus executeCommandRemote(ActivityContext activityContext, String string, String string2, EncryptedString encryptedString, String string3, String string4, String string5, ScriptType scriptType, String string6, boolean bl, SecurityContext securityContext) throws EvFailureException, InterruptedException {
        String string7;
        Object object;
        ExecuteCommandReq executeCommandReq = new ExecuteCommandReq();
        executeCommandReq.getClient().setClientName(string);
        if (string2 != null && string2.length() > 0) {
            executeCommandReq.getUserImpersonation().setUserName(string2);
            if (encryptedString != null && encryptedString.toString().length() > 0) {
                executeCommandReq.getUserImpersonation().setPassword(encryptedString.getPlainText().getBytes());
            }
        }
        executeCommandReq.setStartupPath(string3);
        executeCommandReq.setCommand(string4);
        if (string5 != null && string5.length() > 0) {
            object = new Scanner(string5);
            while (((Scanner)object).hasNextLine()) {
                executeCommandReq.getScriptLines().add(((Scanner)object).nextLine());
            }
            ((Scanner)object).close();
        }
        executeCommandReq.setScriptType(scriptType);
        executeCommandReq.setArguments(string6);
        executeCommandReq.setWaitForProcessCompletion(bl);
        try {
            object = XMLEncoder.encode((Object)executeCommandReq, (PasswordEncryptType)PasswordEncryptType.CVPASSWORD_ENCRYPTION_VER3);
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to encode message App:ExecuteCommandReq", (Throwable)exception);
            this.errorCode = 1;
            this.commandOutput = exception.getMessage();
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "ExecuteCommandReq xml [%s]", new Object[]{WorkflowUtils.maskString((String)object, (String)this.maskedString)});
        try {
            string7 = WorkflowUtils.executeXml((String)object, (CommCellToken)securityContext, (long)activityContext.getJobId(), (String)this.maskedString);
        }
        catch (ExecuteException executeException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to execute message App:ExecuteCommandReq", (Throwable)executeException);
            this.errorCode = executeException.getErrorCode();
            this.commandOutput = executeException.getMessage();
            throw new EvFailureException(new EvMessageContainer(executeException.getMessage()));
        }
        this.setResponse(activityContext, string7, string4, string);
        return AttemptStatus.SUCCESS;
    }

    private AttemptStatus executeCommandLocal(ActivityContext activityContext, String string, String string2, EncryptedString encryptedString, String string3, String string4, String string5, ScriptType scriptType, String string6, boolean bl, SecurityContext securityContext) throws EvFailureException, InterruptedException {
        Object object;
        ClientEntity clientEntity;
        try {
            clientEntity = CommServUtils.getClientEntity((String)string);
        }
        catch (Exception exception) {
            this.errorCode = 1;
            this.commandOutput = exception.getMessage();
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve client information for [" + string + "] on commcell [" + activityContext.getContext().getCommCell().getCommCellName() + "]", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            if (!EvSecurity.isNodeCapability((int)clientEntity.getClientId(), (Capability)Capability.AGENT_MANAGEMENT, (SecurityContext)securityContext)) {
                EvMessageContainer evMessageContainer = EventMessage.getContainer((String)"GUIMSG_SECURITY_USER_CAPABILITY", (Object[])new Object[]{securityContext.getUser().getUserName(), Capability.AGENT_MANAGEMENT.getDisplayName(), string});
                String string7 = EventMessage.getInstance().formatMessage(evMessageContainer, 0);
                logger.error(Long.valueOf(activityContext.getJobId()), string7);
                this.errorCode = 1;
                this.commandOutput = string7;
                throw new EvFailureException(evMessageContainer);
            }
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to check user capabilities", (Throwable)exception);
            this.errorCode = 1;
            this.commandOutput = exception.getMessage();
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        RemoteCommandArguments remoteCommandArguments = new RemoteCommandArguments();
        if (string5 != null && string5.length() > 0) {
            object = new Scanner(string5);
            while (((Scanner)object).hasNextLine()) {
                remoteCommandArguments.getScriptLines().add(((Scanner)object).nextLine());
            }
            ((Scanner)object).close();
        }
        remoteCommandArguments.setRemoteClientId(clientEntity.getClientId());
        remoteCommandArguments.setToolName(string4);
        remoteCommandArguments.setToolParameter(string6);
        remoteCommandArguments.setScriptType(scriptType);
        remoteCommandArguments.setStartUpPath(string3);
        remoteCommandArguments.setGetCommandLine(bl);
        if (string2 != null && string2.length() > 0) {
            remoteCommandArguments.setRunAs(true);
            remoteCommandArguments.setUsername(string2);
            remoteCommandArguments.setPassword(encryptedString.toString());
        } else {
            remoteCommandArguments.setRunAs(false);
            remoteCommandArguments.setUsername(null);
            remoteCommandArguments.setPassword(null);
        }
        remoteCommandArguments.setRequireAuthentication(false);
        try {
            object = XMLEncoder.encode((Object)remoteCommandArguments);
        }
        catch (Exception exception) {
            this.errorCode = 1;
            this.commandOutput = exception.getMessage();
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to encode Workflow::RemoteCommandArguments", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        logger.debug(Long.valueOf(activityContext.getJobId()), "RemoteCommandArguments xml [%s]", new Object[]{object});
        Object object2 = object;
        Callable<String> callable = new Callable<String>((String)object2){
            final /* synthetic */ String val$args;
            {
                this.val$args = string;
            }

            @Override
            public String call() throws Exception {
                return SessionUtil.getInstance().executeCommand(this.val$args);
            }
        };
        Future future = ThreadManager.getInstance().submitTask((Callable)callable);
        Object object3 = activityContext.getLock();
        synchronized (object3) {
            while (true) {
                if (future.isDone()) {
                    String string8 = null;
                    try {
                        string8 = (String)future.get();
                    }
                    catch (ExecutionException executionException) {
                        this.errorCode = 1;
                        this.commandOutput = executionException.getMessage();
                        logger.error(Long.valueOf(activityContext.getJobId()), "error occurred during execution of command", (Throwable)executionException);
                        throw new EvFailureException(new EvMessageContainer(executionException.getMessage()));
                    }
                    this.setResponse(activityContext, string8, string4, string);
                    return AttemptStatus.SUCCESS;
                }
                if (activityContext.getStatus() != ProcessStatus.RUNNING) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since it has a status of [%s]", new Object[]{activityContext.getStatus()});
                    future.cancel(true);
                    return AttemptStatus.FAILED;
                }
                if (!activityContext.isRunning()) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "exiting activity since the workflow is shutting down");
                    future.cancel(true);
                    return AttemptStatus.FAILED;
                }
                activityContext.getLock().wait(1000L);
            }
        }
    }

    private void setResponse(ActivityContext activityContext, String string, String string2, String string3) throws EvFailureException, InterruptedException {
        logger.debug(Long.valueOf(activityContext.getJobId()), "ExecuteToolResp xml [%s]", new Object[]{WorkflowUtils.maskString((String)string, (String)this.maskedString)});
        Object object = null;
        try {
            object = string.toLowerCase().contains("GenericResp".toLowerCase()) ? XMLDecoder.decode((String)string, (Object)new GenericResp()) : XMLDecoder.decode((String)string);
        }
        catch (Exception exception) {
            this.errorCode = 1;
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode xml [" + WorkflowUtils.maskString((String)string, (String)this.maskedString) + "]", (Throwable)exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (!(object instanceof ExecuteToolResp)) {
            if (object instanceof GenericResp) {
                logger.error(Long.valueOf(activityContext.getJobId()), "recieved error code [" + ((GenericResp)object).getErrorCode() + "], message [" + ((GenericResp)object).getErrorMessage() + "]");
                this.errorCode = ((GenericResp)object).getErrorCode();
                throw new EvFailureException(new EvMessageContainer(((GenericResp)object).getErrorMessage()));
            }
            logger.error(Long.valueOf(activityContext.getJobId()), "did not recieve a response of type App::ExecuteToolResp, recieved [" + object.getClass().getName() + "]");
            this.errorCode = 1;
            throw new EvFailureException(new EvMessageContainer("unknown response"));
        }
        ExecuteToolResp executeToolResp = (ExecuteToolResp)object;
        this.exitCode = executeToolResp.getProcessExitCode();
        this.errorCode = executeToolResp.getErrorCode();
        if (this.errorCode != 0 || this.exitCode != 0) {
            if (executeToolResp.getErrorMessage().length() > 0) {
                this.setCommandOuput(executeToolResp.getErrorMessage());
            } else {
                this.setCommandOuput(executeToolResp.getCommandLineOutput());
            }
            if (this.commandOutput.length() == 0 && this.exitCodeMessages != null) {
                this.commandOutput = this.exitCodeMessages.get(this.exitCode);
            }
            logger.error(Long.valueOf(activityContext.getJobId()), "error executing command [" + string2 + "] on host [" + string3 + "], errorCode [" + this.errorCode + "], exitCode [" + this.exitCode + "], error [" + this.commandOutput + "]");
            throw new EvFailureException(new EvMessageContainer(this.commandOutput));
        }
        this.setCommandOuput(executeToolResp.getCommandLineOutput());
    }

    private void setCommandOuput(String string) {
        this.commandOutput = CommandActivity.isStripXMLChars() ? CommandActivity.stripString(string) : StringUtils.stripStart((String)string, (String)STRING_FF);
    }

    public static String stripString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : string.toCharArray()) {
            if (c != '\t' && c != '\n' && c != '\r' && (c < ' ' || c > '\ud7ff') && (c < '\ue000' || c > '\ufffd')) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static {
        char c = '\f';
        STRING_FF = String.valueOf(c);
    }
}

