/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowMail;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.util.List;
import workflow.types.Email;

public class CallActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CallActivity.class);
    @Input(defaultValue="trigger@recipe.ifttt.com")
    public String to;
    @Input
    public String sender;
    @Input
    public String subject;
    @Input
    public String body;
    @Output
    public String errorMessage = "";

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        List list = WorkflowUtils.split((String)this.to);
        if (list.size() == 0) {
            logger.info("did not find any recipients for email, adding workflow executor [%s]", new Object[]{activityContext.getExecutor()});
            list.add("trigger@recipe.ifttt.com");
        }
        if (this.sender == null || this.sender.length() == 0) {
            this.sender = activityContext.getExecutor();
        }
        Email email = new Email();
        email.setTo(this.to);
        email.setFrom(this.sender);
        email.setSubject(this.subject);
        email.setBody(this.body);
        WorkflowMail workflowMail = new WorkflowMail();
        try {
            workflowMail.send((WorkflowContext)activityContext, list, email);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            this.errorMessage = evFailureException.getMessage();
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

