/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.dom.XMLStreamWriter;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ProcessUpdate;

public class AssignValues
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(AssignValues.class);

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        XMLStreamWriter xMLStreamWriter;
        WorkflowElement workflowElement;
        ProcessUpdate processUpdate = new ProcessUpdate();
        if (activityContext.getPostOperations() != null && (activityContext.getPostOperations().getInputs().length() > 0 || activityContext.getPostOperations().getVariables().length() > 0 || activityContext.getPostOperations().getOutputs().length() > 0)) {
            logger.debug(Long.valueOf(activityContext.getJobId()), "processing post operations");
            if (activityContext.getPostOperations().getInputs().length() > 0) {
                try {
                    workflowElement = WorkflowElement.parse((String)activityContext.getPostOperations().getInputs());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error parsing post operation inputs");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                try {
                    xMLStreamWriter = new WorkflowEvaluator(activityContext.getEvaluator());
                    xMLStreamWriter.processElement(workflowElement);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error processing expressions in post operation inputs [" + activityContext.getPostOperations().getInputs() + "]");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                logger.info(Long.valueOf(activityContext.getJobId()), "updating process inputs with xml [%s]", new Object[]{activityContext.getPostOperations().getInputs()});
                activityContext.getWorkflowExecution().mergeInputs(workflowElement);
                processUpdate.setInputs(workflowElement.toString());
            }
            if (activityContext.getPostOperations().getVariables().length() > 0) {
                try {
                    workflowElement = WorkflowElement.parse((String)activityContext.getPostOperations().getVariables());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error parsing post operation variables");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                try {
                    xMLStreamWriter = new WorkflowEvaluator(activityContext.getEvaluator());
                    xMLStreamWriter.processElement(workflowElement);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error processing expressions in post operation variables [" + activityContext.getPostOperations().getVariables() + "]");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                logger.info(Long.valueOf(activityContext.getJobId()), "updating process variables with xml [%s]", new Object[]{String.valueOf(workflowElement)});
                activityContext.getWorkflowExecution().mergeVariables(workflowElement);
                processUpdate.setVariables(workflowElement.toString());
            }
            if (activityContext.getPostOperations().getOutputs().length() > 0) {
                try {
                    workflowElement = WorkflowElement.parse((String)activityContext.getPostOperations().getOutputs());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error parsing post operation outputs");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                try {
                    xMLStreamWriter = new WorkflowEvaluator(activityContext.getEvaluator());
                    xMLStreamWriter.processElement(workflowElement);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "error processing expressions in post operation outputs [" + activityContext.getPostOperations().getOutputs() + "]");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    return AttemptStatus.FAILED;
                }
                logger.info(Long.valueOf(activityContext.getJobId()), "updating process outputs with xml [%s]", new Object[]{String.valueOf(workflowElement)});
                activityContext.getWorkflowExecution().mergeOutputs(workflowElement);
                processUpdate.setOutputs(workflowElement.toString());
            }
        }
        workflowElement = new WorkflowElement("inputs");
        xMLStreamWriter = new XMLStreamWriter(workflowElement);
        try {
            XMLEncoder.encode((Object)processUpdate, (javax.xml.stream.XMLStreamWriter)xMLStreamWriter);
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to encode Workflow::ProcessUpdate message", (Throwable)exception);
        }
        WorkflowElement workflowElement2 = workflowElement.getFirstChild();
        if (workflowElement2 == null) {
            workflowElement2 = new WorkflowElement("inputs");
        } else {
            workflowElement2.setName("inputs");
        }
        activityContext.setActivityInputs(workflowElement2);
        return AttemptStatus.SUCCESS;
    }
}

