/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.qnet.sys.CVPassword;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import workflow.types.Binary;
import workflow.types.NameValue;
import workflow.types.WebMethod;
import workflow.types.WebPostType;
import workflow.types.WebRequest;
import workflow.types.data.DataRow;
import workflow.types.data.MetaData;

public abstract class AbstractHttpClientActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(AbstractHttpClientActivity.class);
    @Output
    public String output;
    @Output
    public int statusCode;
    @Output
    public String statusText;
    @Output
    public DataRow headers;
    private Integer httpTimeout = null;
    private Boolean useHttpProxy = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus executeRequest(WebRequest webRequest, ActivityContext activityContext) {
        HttpEntity httpEntity;
        SSLConnectionSocketFactory sSLConnectionSocketFactory;
        SSLContext sSLContext;
        NameValue nameValue2;
        Object object;
        Object object22;
        Object object3;
        WorkflowProperties.WebServiceParameters webServiceParameters;
        if (webRequest == null) {
            webRequest = new WebRequest();
        }
        if (webRequest.getUrl() == null || webRequest.getUrl().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no url provided");
            activityContext.setFailureReason("missing url");
            return AttemptStatus.FAILED;
        }
        if (webRequest.getUrl().startsWith("/")) {
            webServiceParameters = activityContext.getContext().getDefaultWebService();
            if (webServiceParameters != null) {
                object3 = webServiceParameters.getWebUrl();
                if (!webRequest.getUrl().toLowerCase().contains("CVWebService.svc".toLowerCase())) {
                    object3 = ((String)object3).endsWith("/") ? object3 + webServiceParameters.getBasePath() : object3 + "/" + webServiceParameters.getBasePath();
                }
                logger.debug("url starts with '/' prepending default web service url [" + object3 + "]");
                webRequest.setUrl((String)object3 + webRequest.getUrl());
            } else {
                logger.warn("no default web server found on CommCell to prepend to url [" + webRequest.getUrl() + "]");
            }
        }
        if (webRequest.getMethod() == null) {
            logger.info(Long.valueOf(activityContext.getJobId()), "web method not provided into activity, defaulting to Get");
            webRequest.setMethod(WebMethod.GET);
        }
        try {
            webServiceParameters = new URIBuilder(webRequest.getUrl());
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build the uri from url [" + webRequest.getUrl() + "]", (Throwable)uRISyntaxException);
            activityContext.setFailureReason(uRISyntaxException.getMessage());
            return AttemptStatus.FAILED;
        }
        if (webRequest.getParameters() != null && webRequest.getParameters().size() > 0) {
            for (Object object22 : webRequest.getParameters()) {
                webServiceParameters.addParameter(object22.getName(), object22.getValue());
            }
        }
        try {
            object3 = webServiceParameters.build();
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build the uri from url [" + webRequest.getUrl() + "], parameters [" + webRequest.getParameters() + "]", (Throwable)uRISyntaxException);
            activityContext.setFailureReason(uRISyntaxException.getMessage());
            return AttemptStatus.FAILED;
        }
        logger.debug("HTTP Client URL: " + ((URI)object3).toASCIIString());
        object22 = null;
        if (webRequest.getMethod() == WebMethod.GET) {
            object22 = new HttpGet((URI)object3);
        } else {
            if (webRequest.getMethod() == WebMethod.POST) {
                object22 = new HttpPost((URI)object3);
            } else if (webRequest.getMethod() == WebMethod.DELETE) {
                object22 = new HttpDeleteWithBody((URI)object3);
            } else if (webRequest.getMethod() == WebMethod.PUT) {
                object22 = new HttpPut((URI)object3);
            } else if (webRequest.getMethod() == WebMethod.PATCH) {
                object22 = new HttpPatch((URI)object3);
            }
            if (webRequest.getPostType() != null) {
                UrlEncodedFormEntity urlEncodedFormEntity;
                if (webRequest.getPostType() == WebPostType.Form) {
                    object = new ArrayList();
                    if (webRequest.getPostParameters() != null) {
                        for (NameValue nameValue2 : webRequest.getPostParameters()) {
                            logger.debug(Long.valueOf(activityContext.getJobId()), "Form Parameter: Name [%s], Value [%s]", new Object[]{nameValue2.getName(), nameValue2.getValue()});
                            object.add(new BasicNameValuePair(nameValue2.getName(), nameValue2.getValue()));
                        }
                    }
                    try {
                        urlEncodedFormEntity = new UrlEncodedFormEntity((List)object);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "failed to build form from parameters " + object, (Throwable)unsupportedEncodingException);
                        activityContext.setFailureReason(unsupportedEncodingException.getMessage());
                        return AttemptStatus.FAILED;
                    }
                } else {
                    if (webRequest.getPostContent() == null) {
                        webRequest.setPostContent((Object)"");
                    }
                    object = null;
                    object = webRequest.getPostContentType() != null && webRequest.getPostContentType().length() > 0 ? ContentType.parse((String)webRequest.getPostContentType()) : ContentType.TEXT_PLAIN;
                    logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Content Type: [%s]", new Object[]{object.getMimeType()});
                    logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Charset: [%s]", new Object[]{object.getCharset()});
                    if (webRequest.getPostContent() instanceof File) {
                        urlEncodedFormEntity = new FileEntity((File)webRequest.getPostContent(), (ContentType)object);
                        logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP File: [%s]", new Object[]{((File)webRequest.getPostContent()).getAbsolutePath()});
                    } else if (webRequest.getPostContent() instanceof Binary) {
                        urlEncodedFormEntity = new ByteArrayEntity(((Binary)webRequest.getPostContent()).getBytes(), (ContentType)object);
                    } else {
                        urlEncodedFormEntity = WorkflowRegistry.getInstance().isForceHttpUtf8() ? new StringEntity(String.valueOf(webRequest.getPostContent()), "UTF-8") : new StringEntity(String.valueOf(webRequest.getPostContent()), (ContentType)object);
                        logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Content: [%s]", new Object[]{String.valueOf(webRequest.getPostContent())});
                    }
                    logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Content Length: [%s]", new Object[]{urlEncodedFormEntity.getContentLength()});
                }
                ((HttpEntityEnclosingRequest)object22).setEntity((HttpEntity)urlEncodedFormEntity);
            }
        }
        int n = this.getHttpTimeout(activityContext);
        if (n > 0) {
            object = RequestConfig.custom();
            object.setConnectTimeout(n * 1000);
            object.setConnectionRequestTimeout(n * 1000);
            object.setSocketTimeout(n * 1000);
            object22.setConfig(object.build());
        }
        if (webRequest.getHeaders() != null && webRequest.getHeaders().size() > 0) {
            for (NameValue nameValue3 : webRequest.getHeaders()) {
                logger.debug("HEADER: name [%s] value [%s]", new Object[]{nameValue3.getName(), nameValue3.getValue()});
                object22.addHeader(nameValue3.getName(), nameValue3.getValue());
            }
        }
        object = HttpClients.custom();
        object.useSystemProperties();
        boolean bl = false;
        if (this.useHttpProxy != null) {
            bl = this.useHttpProxy;
        } else {
            boolean bl2 = bl = WorkflowRegistry.getInstance().isUseHttpProxy() && activityContext.getJobSettings().isHttpUseProxy();
        }
        if (bl) {
            logger.info(Long.valueOf(activityContext.getJobId()), "using http proxy [%s], port [%s] for url address [%s]", new Object[]{activityContext.getJobSettings().getHttpProxySite(), activityContext.getJobSettings().getHttpProxyPort(), webRequest.getUrl()});
            nameValue2 = new HttpHost(activityContext.getJobSettings().getHttpProxySite(), activityContext.getJobSettings().getHttpProxyPort());
            object.setProxy((HttpHost)nameValue2);
            if (activityContext.getJobSettings().isHttpUseProxyAuthentication()) {
                logger.debug(Long.valueOf(activityContext.getJobId()), "HTTP Proxy Username: [%s]", new Object[]{activityContext.getJobSettings().getHttpProxyUser()});
                sSLContext = new CVPassword();
                sSLConnectionSocketFactory = new BasicCredentialsProvider();
                sSLConnectionSocketFactory.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(activityContext.getJobSettings().getHttpProxyUser(), sSLContext.decrypt(activityContext.getJobSettings().getHttpProxyPassword())));
                object.setDefaultCredentialsProvider((CredentialsProvider)sSLConnectionSocketFactory);
            }
        }
        if (WorkflowRegistry.getInstance().isValidateSSL()) {
            nameValue2 = object.build();
        } else {
            try {
                sSLContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, new String[]{"TLSv1"}, null, (HostnameVerifier)new NoopHostnameVerifier());
                nameValue2 = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sSLConnectionSocketFactory).build();
            }
            catch (Exception exception) {
                logger.error("failed to configure http client to ignore SSL certificate errors", (Throwable)exception);
                nameValue2 = object.build();
            }
        }
        sSLContext = null;
        sSLConnectionSocketFactory = new LinkedHashMap();
        try {
            sSLContext = nameValue2.execute((HttpUriRequest)object22);
            httpEntity = sSLContext.getEntity();
            if (httpEntity != null) {
                this.output = this.fixOutput(IOUtils.toString((InputStream)new BOMInputStream(httpEntity.getContent()), (String)"UTF-8"));
            }
            this.statusCode = sSLContext.getStatusLine().getStatusCode();
            this.statusText = sSLContext.getStatusLine().getReasonPhrase();
            for (Header header : sSLContext.getAllHeaders()) {
                sSLConnectionSocketFactory.put(header.getName(), header.getValue());
            }
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to read response from url [" + webRequest.getUrl() + "]", (Throwable)exception);
            activityContext.setFailureReason(exception.getMessage());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        finally {
            if (sSLContext != null) {
                try {
                    sSLContext.close();
                }
                catch (IOException iOException) {
                    logger.error(Long.valueOf(activityContext.getJobId()), "failed to close http response object", (Throwable)iOException);
                }
            }
        }
        httpEntity = new MetaData(sSLConnectionSocketFactory.keySet().toArray(new String[0]));
        this.headers = new DataRow((MetaData)httpEntity, sSLConnectionSocketFactory.values().toArray());
        return AttemptStatus.SUCCESS;
    }

    private String fixOutput(String string) {
        if (!string.contains("X1|")) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (char c : cArray) {
            if (c != 'X' && c != '1' && c != '|') break;
            ++n;
        }
        Object object = new StringBuffer();
        for (int i = n; i < cArray.length; ++i) {
            ((StringBuffer)object).append(cArray[i]);
        }
        return ((StringBuffer)object).toString();
    }

    private int getHttpTimeout(ActivityContext activityContext) {
        if (this.httpTimeout == null) {
            if (activityContext.getActivityTimeout() > 0) {
                return activityContext.getActivityTimeout() * 60;
            }
            return WorkflowRegistry.getInstance().getHttpTimeout();
        }
        return this.httpTimeout;
    }

    public void setHttpTimeout(int n) {
        this.httpTimeout = n;
    }

    class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpDeleteWithBody(String string) {
            this.setURI(URI.create(string));
        }

        public HttpDeleteWithBody(URI uRI) {
            this.setURI(uRI);
        }

        public HttpDeleteWithBody() {
        }
    }
}

